/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import com.ca.adr.BCadrNetwork;
import com.ca.adr.util.Base64Util;
import com.ca.adr.util.Logging;
import com.tridium.asm.Buffer;
import com.tridium.sys.module.AutoClassLoader;
import java.util.LinkedList;

public class ThreadPool
implements Logging {
    private boolean alive = true;
    private int idleThreads = 0;
    private final LinkedList list = new LinkedList();
    private final int min;
    private final String name;
    private int numThreads = 0;
    private Object mutex;

    public ThreadPool() {
        this.name = "Comfort ADR";
        this.min = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Runnable r) {
        Object object = this.mutex;
        synchronized (object) {
            this.list.add(r);
            this.checkThreads();
            this.mutex.notify();
        }
    }

    public boolean init(BCadrNetwork owner) {
        this.initMutex(owner);
        return this.mutex != null;
    }

    public void shutdown() {
        this.alive = false;
    }

    protected void checkThreads() {
        if (this.idleThreads == 0) {
            ++this.numThreads;
            new MyThread(this.name).start();
        }
    }

    protected void finalize() throws Throwable {
        this.alive = false;
    }

    private Runnable dequeue() {
        if (this.list.size() == 0) {
            return null;
        }
        this.checkThreads();
        return (Runnable)this.list.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMutex(BCadrNetwork owner) {
        try {
            if (this.mutex == null) {
                Class c = null;
                String name = "com.ca.adr.util.Mutex";
                try {
                    Class.forName(name);
                }
                catch (Exception e) {
                    byte[] buf = Base64Util.fastMap();
                    Buffer buffer = new Buffer();
                    buffer.append(buf);
                    c = AutoClassLoader.load(ThreadPool.class, (String)"auto.CadrMutex", (Buffer)buffer);
                }
                this.mutex = c.newInstance();
            }
            if (!this.mutex.equals(owner)) {
                this.mutex = null;
            }
            return;
        }
        catch (Throwable x) {
            this.error(owner.toPathString(), x);
            owner.configFatal("Cannot initialize threads, try rebooting");
            Class<ThreadPool> clazz = ThreadPool.class;
            synchronized (ThreadPool.class) {
                ThreadPool.class.notify();
                // ** MonitorExit[var2_4] (shouldn't be in output)
                return;
            }
        }
    }

    private class MyThread
    extends Thread {
        public MyThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Runnable r = null;
                while (ThreadPool.this.alive) {
                    long start = System.currentTimeMillis();
                    Object object = ThreadPool.this.mutex;
                    synchronized (object) {
                        ThreadPool.this.idleThreads++;
                        while (r == null && ThreadPool.this.alive) {
                            r = ThreadPool.this.dequeue();
                            if (r != null) continue;
                            if (System.currentTimeMillis() - start > 30000L && ThreadPool.this.numThreads > ThreadPool.this.min) {
                                ThreadPool.this.idleThreads--;
                                return;
                            }
                            try {
                                ThreadPool.this.mutex.wait(5000L);
                            }
                            catch (Exception exception) {}
                        }
                        ThreadPool.this.idleThreads--;
                        ThreadPool.this.mutex.notify();
                        ThreadPool.this.checkThreads();
                        if (r == null) continue;
                    }
                    r.run();
                    r = null;
                }
                return;
            }
            catch (Exception x) {
                ThreadPool.this.error("", x);
                return;
            }
            finally {
                Object object = ThreadPool.this.mutex;
                synchronized (object) {
                    ThreadPool.this.numThreads--;
                }
            }
        }
    }
}

