/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import java.util.Vector;
import javax.baja.naming.SlotPath;

public class Strings {
    private Strings() {
    }

    public static String concatUris(String base, String path) {
        if (path == null || path.equals("")) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                return base + path.substring(1);
            }
        } else if (!path.startsWith("/")) {
            return base + "/" + path;
        }
        return base + path;
    }

    public static String[] fields(String row) {
        StringBuilder buf = new StringBuilder(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch < '!' || ch > '~') {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static String[] fields(String row, char delim) {
        StringBuilder buf = new StringBuilder(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch == delim) {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static String fromFriendly(String s) {
        char c;
        int i;
        StringBuilder buf = new StringBuilder(s.length());
        buf.append(Character.toLowerCase(s.charAt(0)));
        int len = s.length();
        for (i = 1; i < len && (c = s.charAt(i)) != ' '; ++i) {
            buf.append(c);
        }
        while (i < len) {
            c = s.charAt(i);
            if (c != ' ') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getAsciiChars(String s) {
        int len = s.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                buf.append(ch);
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                buf.append(ch);
                continue;
            }
            if (ch < '0' || ch > '9') continue;
            buf.append(ch);
        }
        return buf.toString().trim();
    }

    public static String getNumber(String src) {
        int len = src.length();
        StringBuilder buf = new StringBuilder();
        boolean hasDec = false;
        boolean hasDigits = false;
        boolean hasMinus = false;
        boolean hasExp = false;
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch == '-' && !hasMinus) {
                buf.append('-');
                hasMinus = true;
                continue;
            }
            if (ch == '.' && !hasDec) {
                buf.append(ch);
                hasDec = true;
                continue;
            }
            if (Character.isDigit(ch)) {
                buf.append(ch);
                hasDigits = true;
                continue;
            }
            if (!(ch != 'e' && ch != 'E' || hasExp)) {
                if (!hasDigits) continue;
                String sciNot = "e";
                if (i + 1 >= len) continue;
                char nextChar = src.charAt(i + 1);
                if (nextChar == '-' || nextChar == '+') {
                    if (i + 2 >= len) break;
                    sciNot = sciNot + nextChar;
                    nextChar = src.charAt(i + 2);
                    ++i;
                }
                if (!Character.isDigit(nextChar)) break;
                buf.append(sciNot);
                hasExp = true;
                continue;
            }
            if (hasDigits) break;
        }
        src = buf.toString();
        return src;
    }

    public static int indexOf(StringBuffer buffer, String pattern) {
        return Strings.indexOf(buffer, pattern, 0);
    }

    public static int indexOf(StringBuffer buffer, String pattern, int fromIndex) {
        int z;
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (pattern == null) {
            throw new NullPointerException();
        }
        int[] overlap = Strings.computeOverlap(pattern);
        int j = 0;
        int n = buffer.length();
        int m = pattern.length();
        block0: for (int i = z = Math.max(fromIndex, 0); i < n; ++i) {
            while (true) {
                if (buffer.charAt(i) == pattern.charAt(j)) {
                    if (++j != m) continue block0;
                    return i - m + 1;
                }
                if (j == 0) continue block0;
                j = overlap[j];
            }
        }
        return -1;
    }

    public static String makeHistoryName(String prefix, String deviceName, String pointName) {
        prefix = Strings.scrub(prefix);
        deviceName = Strings.scrub(deviceName);
        pointName = Strings.scrub(pointName);
        int reserved = prefix.length() + 2;
        int partLen = (10 - reserved) / 2;
        int len = reserved + deviceName.length() + pointName.length();
        if (len > 40) {
            pointName = Strings.scrubPoint(pointName, partLen);
            len = reserved + deviceName.length() + pointName.length();
            if (len > 40) {
                if (deviceName.length() > partLen && pointName.length() > partLen) {
                    pointName = Strings.shorten(pointName, partLen);
                    deviceName = Strings.shorten(deviceName, partLen);
                } else if (deviceName.length() > partLen) {
                    len = partLen + (partLen - pointName.length());
                    deviceName = Strings.shorten(deviceName, len);
                } else {
                    len = partLen + (partLen - deviceName.length());
                    pointName = Strings.shorten(pointName, len);
                }
            }
        }
        return prefix + "_" + deviceName + "_" + pointName;
    }

    public static String replace(String text, String oldStr, String newStr) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (oldStr == null) {
            throw new NullPointerException();
        }
        if (newStr == null) {
            throw new NullPointerException();
        }
        int b = text.indexOf(oldStr);
        if (b == -1) {
            return text;
        }
        return Strings.doReplace(new StringBuffer(text), oldStr, newStr, b).toString();
    }

    public static StringBuffer replace(StringBuffer text, String oldStr, String newStr) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (oldStr == null) {
            throw new NullPointerException();
        }
        if (newStr == null) {
            throw new NullPointerException();
        }
        int b = Strings.indexOf(text, oldStr, 0);
        if (b == -1) {
            return text;
        }
        return Strings.doReplace(text, oldStr, newStr, b);
    }

    public static String toFriendly(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append(Character.toUpperCase(s.charAt(0)));
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if ((c & 0x20) == 0) {
                buf.append(' ').append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static int[] computeOverlap(String pattern) {
        int m = pattern.length();
        int[] overlap = new int[m + 1];
        overlap[0] = -1;
        for (int i = 0; i < m; ++i) {
            overlap[i + 1] = overlap[i] + 1;
            while (overlap[i + 1] > 0 && pattern.charAt(i) != pattern.charAt(overlap[i + 1] - 1)) {
                overlap[i + 1] = overlap[overlap[i + 1] - 1] + 1;
            }
        }
        return overlap;
    }

    private static StringBuffer doReplace(StringBuffer text, String oldStr, String newStr, int b) {
        int n1 = oldStr.length();
        int n2 = newStr.length();
        while (b != -1) {
            text.replace(b, b + n1, newStr);
            b = Strings.indexOf(text, oldStr, b + n2);
        }
        return text;
    }

    private static String scrub(String name) {
        name = Strings.toFriendly(SlotPath.unescape((String)name));
        StringBuilder buf = new StringBuilder();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    private static String scrubPoint(String name, int maxlen) {
        StringBuffer buf = new StringBuffer(name);
        if (buf.length() > maxlen) {
            Strings.replace(buf, "AnalogInput", "AI");
            Strings.replace(buf, "AnalogOutput", "AO");
            Strings.replace(buf, "AnalogValue", "AV");
            Strings.replace(buf, "BinaryInput", "BI");
            Strings.replace(buf, "BinaryOutput", "BO");
            Strings.replace(buf, "BinaryValue", "BV");
        }
        if (buf.length() > maxlen) {
            Strings.replace(buf, "Analog", "Ana");
            Strings.replace(buf, "Binary", "Bin");
            Strings.replace(buf, "Digital", "Dig");
            Strings.replace(buf, "MultiState", "Multi");
            Strings.replace(buf, "Multistate", "Multi");
        }
        if (buf.length() > maxlen) {
            Strings.replace(buf, "Property", "Prop");
            Strings.replace(buf, "Output", "Out");
            Strings.replace(buf, "Input", "In");
            Strings.replace(buf, "Value", "Val");
        }
        if (buf.length() > maxlen) {
            Strings.replace(buf, "Setpoint", "Sp");
            Strings.replace(buf, "SetPoint", "Sp");
            Strings.replace(buf, "Supply", "Sup");
            Strings.replace(buf, "Return", "Ret");
            Strings.replace(buf, "Meter", "Mtr");
            Strings.replace(buf, "Point", "Pt");
        }
        return buf.toString();
    }

    private static String shorten(String name, int len) {
        StringBuilder buf = new StringBuilder();
        int div = len / 2;
        buf.append(name, 0, div);
        buf.append('-');
        buf.append(name.substring(name.length() - (len -= buf.length())));
        return buf.toString();
    }
}

