/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class Duration {
    private static final long mshr = 3600000L;
    private static final long msmn = 60000L;
    public boolean negative = false;
    public int years = 0;
    public int months = 0;
    public int days = 0;
    public int hours = 0;
    public int minutes = 0;
    public int seconds = 0;
    public int millis = 0;

    public Duration() {
    }

    public Duration(boolean neg, int years, int months, int days) {
        this.negative = neg;
        this.years = years;
        this.months = months;
        this.days = days;
    }

    public Duration(boolean neg, int days, int hours, int minutes, int seconds, int millis) {
        this.negative = neg;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.millis = millis;
    }

    public Duration(boolean neg, int hours, int minutes, int seconds, int millis) {
        this.negative = neg;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.millis = millis;
    }

    public Duration(Duration clone) {
        this.negative = clone.negative;
        this.years = clone.years;
        this.months = clone.months;
        this.days = clone.days;
        this.hours = clone.hours;
        this.minutes = clone.minutes;
        this.seconds = clone.seconds;
        this.millis = clone.millis;
    }

    public BAbsTime addTo(BAbsTime t) {
        if (this.negative) {
            return this.subtract(t);
        }
        int n = this.years;
        if (n > 0) {
            while (--n >= 0) {
                t = t.nextYear();
            }
        }
        if ((n = this.months) > 0) {
            while (--n >= 0) {
                t = t.nextMonth();
            }
        }
        if ((n = this.days) > 0) {
            while (--n >= 0) {
                t = t.nextDay();
            }
        }
        if ((n = this.hours) > 0) {
            t = t.add(BRelTime.make((long)(3600000L * (long)n)));
        }
        if ((n = this.minutes) > 0) {
            t = t.add(BRelTime.make((long)(60000L * (long)n)));
        }
        if ((n = this.seconds) > 0) {
            t = t.add(BRelTime.make((long)(1000 * n)));
        }
        if ((n = this.millis) > 0) {
            t = t.add(BRelTime.make((long)n));
        }
        return t;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMillis() {
        return this.millis;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getMonths() {
        return this.months;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getYears() {
        return this.years;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public static Duration make(BRelTime arg) {
        long millis = (int)arg.getMillis();
        boolean neg = false;
        if (millis < 0L) {
            millis = -millis;
            neg = true;
        }
        int days = (int)(millis / 86400000L);
        int hours = (int)((millis %= 86400000L) / 3600000L);
        int mins = (int)((millis %= 3600000L) / 60000L);
        int secs = (int)((millis %= 60000L) / 1000L);
        return new Duration(neg, days, hours, mins, secs, (int)(millis %= 1000L));
    }

    public static Duration make(String s) {
        Duration ret = new Duration();
        if (s == null || s.length() == 0) {
            return ret;
        }
        try {
            int num;
            DurationParser p = new DurationParser(s);
            if (p.cur == 45) {
                ret.negative = true;
                p.consume();
            } else if (p.cur == 43) {
                p.consume();
            }
            p.consume(80);
            if (p.cur == -1) {
                throw new Exception();
            }
            if (p.cur != 84) {
                num = p.num();
                if (p.cur == 89) {
                    p.consume();
                    ret.years = num;
                    num = p.num();
                }
                if (p.cur == 77) {
                    p.consume();
                    ret.months = num;
                    num = p.num();
                }
                if (p.cur == 68) {
                    p.consume();
                    ret.days = num;
                }
            }
            if (p.cur == 84) {
                p.consume();
                num = p.num();
                if (p.cur == 72) {
                    p.consume();
                    ret.hours = num;
                    num = p.num();
                }
                if (p.cur == 77) {
                    p.consume();
                    ret.minutes = num;
                    num = p.num();
                }
                if (p.cur == 46) {
                    p.consume();
                    ret.seconds = num;
                    ret.millis = p.num();
                } else if (p.cur == 83) {
                    ret.seconds = num;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid duration: " + s);
        }
        return ret;
    }

    public BRelTime toRelTime() {
        long val = 3600000L * (long)this.hours;
        val += 60000L * (long)this.minutes;
        val += (long)(1000 * this.seconds);
        return BRelTime.make((long)(val += (long)this.millis));
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.negative) {
            ret.append('-');
        }
        ret.append('P');
        if (this.years > 0) {
            ret.append(this.years).append('Y');
        }
        if (this.months > 0) {
            ret.append(this.months).append('M');
        }
        if (this.days > 0) {
            ret.append(this.days).append('D');
        }
        if (this.hours > 0 || this.minutes > 0 || this.seconds > 0 || this.millis > 0) {
            ret.append('T');
            if (this.hours > 0) {
                ret.append(this.hours).append('H');
            }
            if (this.minutes > 0) {
                ret.append(this.minutes).append('M');
            }
            if (this.millis == 0) {
                if (this.seconds > 0) {
                    ret.append(this.seconds).append('S');
                }
            } else if (this.seconds == 0) {
                ret.append("0.").append(this.millis).append('S');
            } else {
                ret.append(this.seconds).append('.').append(this.millis).append('S');
            }
        }
        return ret.toString();
    }

    private BAbsTime subtract(BAbsTime t) {
        int n = this.years;
        if (n > 0) {
            while (--n >= 0) {
                t = t.prevYear();
            }
        }
        if ((n = this.months) > 0) {
            while (--n >= 0) {
                t = t.prevMonth();
            }
        }
        if ((n = this.days) > 0) {
            while (--n >= 0) {
                t = t.prevDay();
            }
        }
        if ((n = this.hours) > 0) {
            t = t.subtract(BRelTime.make((long)(3600000L * (long)n)));
        }
        if ((n = this.minutes) > 0) {
            t = t.subtract(BRelTime.make((long)(60000L * (long)n)));
        }
        if ((n = this.seconds) > 0) {
            t = t.subtract(BRelTime.make((long)(1000 * n)));
        }
        if ((n = this.millis) > 0) {
            t = t.subtract(BRelTime.make((long)n));
        }
        return t;
    }

    private static class DurationParser {
        final String s;
        int off;
        int cur;
        boolean curIsDigit;

        DurationParser(String s) {
            this.s = s;
            this.cur = s.charAt(0);
        }

        int num() {
            int num = 0;
            while (this.curIsDigit) {
                num = num * 10 + this.digit();
                this.consume();
            }
            return num;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int ch) {
            if (this.cur != ch) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                this.curIsDigit = 48 <= this.cur && this.cur <= 57;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }
    }
}

