/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import com.ca.adr.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class Csv {
    private static final ThreadLocal buf1 = new MyThreadLocal();
    private static final ThreadLocal buf2 = new MyThreadLocal();

    public static String makeCell(String s) {
        StringBuffer tmp = (StringBuffer)buf1.get();
        tmp.setLength(0);
        Csv.makeCell(s, false, tmp);
        return tmp.toString();
    }

    public static StringBuffer makeCell(String s, StringBuffer ret) {
        return Csv.makeCell(s, false, ret);
    }

    public static StringBuffer makeCell(String s, boolean forceQuotes, StringBuffer ret) {
        boolean quotes;
        if (ret == null) {
            ret = new StringBuffer();
        }
        boolean bl = quotes = forceQuotes || s.indexOf(44) >= 0;
        if (quotes && !s.startsWith("\"")) {
            ret.append('\"');
        }
        if (s.indexOf(34) >= 0) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    ret.append(c);
                }
                ret.append(c);
            }
        } else {
            ret.append(s);
        }
        if (quotes && !s.endsWith("\"")) {
            ret.append('\"');
        }
        return ret;
    }

    public static StringBuffer makeRow(ArrayList row, char delim, StringBuffer ret) {
        if (ret == null) {
            ret = new StringBuffer(100);
        } else {
            ret.setLength(0);
        }
        int len = row.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                ret.append(delim);
            }
            Csv.makeCell(row.get(i).toString().trim(), ret);
        }
        return ret;
    }

    public static StringBuffer makeRow(String[] row, char delim, StringBuffer ret) {
        if (ret == null) {
            ret = new StringBuffer(100);
        } else {
            ret.setLength(0);
        }
        int len = row.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                ret.append(delim);
            }
            Csv.makeCell(row[i].trim(), ret);
        }
        return ret;
    }

    public static String readCell(String s) {
        if ((s = s.trim()).indexOf(34) < 0) {
            return s;
        }
        int len = s.length() - 1;
        if (len > 1) {
            if (s.charAt(0) == '\"' && s.charAt(len) == '\"') {
                s = s.substring(1, len);
            }
            s = Strings.replace(s, "\"\"", "\"");
        }
        return s;
    }

    public static ArrayList readRow(CharSequence row, char delim, ArrayList ret) {
        if (ret == null) {
            ret = new ArrayList<String>();
        } else {
            ret.clear();
        }
        int len = row.length();
        if (len == 0) {
            return ret;
        }
        StringBuffer tmpBuf = (StringBuffer)buf1.get();
        tmpBuf.setLength(0);
        boolean inquote = false;
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch == delim) {
                if (inquote) {
                    tmpBuf.append(ch);
                    continue;
                }
                if (delim == ' ' && tmpBuf.length() == 0) continue;
                ret.add(Csv.readCell(tmpBuf.toString()));
                tmpBuf.setLength(0);
                continue;
            }
            if (ch == '\"') {
                inquote = !inquote;
                tmpBuf.append(ch);
                continue;
            }
            tmpBuf.append(ch);
        }
        if (tmpBuf.length() > 0) {
            ret.add(Csv.readCell(tmpBuf.toString()));
        }
        return ret;
    }

    public static ArrayList readRow(Reader in, char delim, ArrayList ret) throws IOException {
        ret.clear();
        StringBuffer tmpBuf = (StringBuffer)buf2.get();
        tmpBuf.setLength(0);
        int ch = in.read();
        while (ch >= 0) {
            switch (ch) {
                case 10: {
                    return Csv.readRow(tmpBuf, delim, ret);
                }
                case 13: {
                    break;
                }
                default: {
                    tmpBuf.append((char)ch);
                }
            }
            ch = in.read();
        }
        if (tmpBuf.length() > 0) {
            return Csv.readRow(tmpBuf, delim, ret);
        }
        return ret;
    }

    public static void skipRow(Reader in) throws IOException {
        int ch = in.read();
        while (ch >= 0) {
            if (ch == 10) {
                return;
            }
            ch = in.read();
        }
    }

    public static void skipRows(int count, Reader in) throws IOException {
        int ch = in.read();
        while (ch >= 0) {
            if (ch == 10 && --count == 0) {
                return;
            }
            ch = in.read();
        }
    }

    public static void skipRows(int count, BufferedReader in) throws IOException {
        while (--count >= 0) {
            in.readLine();
        }
    }

    private static class MyThreadLocal
    extends ThreadLocal {
        protected synchronized Object initialValue() {
            return new StringBuffer();
        }
    }
}

