/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import com.ca.adr.CadrConstants;
import com.ca.adr.util.Logging;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public abstract class BCadrTargets
extends BSimple
implements CadrConstants,
Logging {
    public static final Type TYPE = Sys.loadType(BCadrTargets.class);
    private static final BIcon icon = BIcon.std((String)"match.png");
    static final String WILD = "*";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String encoded = null;
    private ArrayList entries;

    public Type getType() {
        return TYPE;
    }

    protected BCadrTargets() {
    }

    protected BCadrTargets(String encoded) {
        this.encoded = encoded == null ? WILD : encoded;
    }

    public BCadrTargets add(String key, String value) {
        if (key == null || key.length() == 0) {
            key = WILD;
        }
        if (value == null || value.length() == 0) {
            value = WILD;
        }
        if (key.equals(WILD) && value.equals(WILD)) {
            return this.getNull();
        }
        if (this.contains(key, value)) {
            return this;
        }
        BCadrTargets ret = this.newInstance();
        ret.entries = this.isNull() ? new ArrayList() : BCadrTargets.clone(this.getEntries());
        ret.entries.add(new Entry(key, value));
        return ret;
    }

    public boolean contains(String key, String value) {
        if (this.entries == null) {
            return false;
        }
        ArrayList entries = this.getEntries();
        int i = entries.size();
        while (--i >= 0) {
            Entry e = (Entry)entries.get(i);
            if (!e.equals(key, value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String key) {
        if (this.entries == null) {
            return false;
        }
        ArrayList entries = this.getEntries();
        int i = entries.size();
        while (--i >= 0) {
            Entry e = (Entry)entries.get(i);
            if (!e.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public BCadrTargets decodeXml(XElem[] eiTargetKids) {
        BCadrTargets tgts = this;
        if (eiTargetKids == null) {
            return tgts;
        }
        int len = eiTargetKids.length;
        if (len == 0) {
            return tgts;
        }
        block17: for (XElem eiTargetKid : eiTargetKids) {
            String name;
            switch (name = eiTargetKid.name()) {
                case "endDeviceAsset": 
                case "meterAsset": 
                case "aggregatedPnode": 
                case "pointOfDelievery": 
                case "pointOfReceipt": 
                case "pnode": 
                case "serviceDeliveryPoint": {
                    XElem[] ary;
                    for (XElem xElem : ary = eiTargetKid.elems()) {
                        tgts = tgts.add(name, xElem.string());
                    }
                    continue block17;
                }
                case "transportInterface": {
                    tgts = tgts.decodeXml(eiTargetKid.elems());
                    continue block17;
                }
                case "serviceLocation": 
                case "serviceArea": {
                    continue block17;
                }
                default: {
                    tgts = tgts.add(name, eiTargetKid.string());
                }
            }
        }
        return tgts;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public String encodeToString() {
        if (this.encoded != null) {
            return this.encoded;
        }
        if (this.isNull()) {
            return WILD;
        }
        StringBuffer buf = new StringBuffer();
        ArrayList entries = this.getEntries();
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            Entry e = (Entry)entries.get(i);
            if (i > 0) {
                buf.append(',');
            }
            BCadrTargets.write(e.getKey(), buf);
            buf.append('=');
            BCadrTargets.write(e.getValue(), buf);
        }
        this.encoded = buf.toString();
        return this.encoded;
    }

    public void encodeXml(XElem parent) {
        ArrayList list = this.getEntries();
        for (Object o : list) {
            Entry e = (Entry)o;
            String n = e.getKey();
            if (n.equals("aggregatedPnode") || n.equals("endDeviceAsset") || n.equals("meterAsset") || n.equals("pnode") || n.equals("serviceDeliveryPoint")) {
                parent.addContent((XContent)BCadrTargets.x(nsPower, n, BCadrTargets.x(nsPower, "mrid", e.getValue())));
                continue;
            }
            parent.addContent((XContent)BCadrTargets.x(nsEi, n, e.getValue()));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCadrTargets) {
            BCadrTargets arg = (BCadrTargets)o;
            ArrayList mine = this.getEntries();
            if (arg.getEntries().size() != mine.size()) {
                return false;
            }
            for (Object value : mine) {
                Entry e = (Entry)value;
                if (arg.contains(e.getKey(), e.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ArrayList getAllEntries(ArrayList list) {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList e = this.getEntries();
        list.addAll(e);
        return list;
    }

    public abstract BCadrTargets getNull();

    public BIcon getIcon() {
        return icon;
    }

    public int hashCode() {
        return this.encodeToString().hashCode();
    }

    public boolean matches(BCadrTargets arg) {
        if (this.isNull()) {
            return true;
        }
        if (arg.isNull()) {
            return true;
        }
        ArrayList list = this.getEntries();
        int len = arg.size();
        for (int i = 0; i < len; ++i) {
            Entry e = (Entry)list.get(i);
            if (!(e.getValue().equals(WILD) ? arg.containsKey(e.getKey()) : arg.contains(e.getKey(), e.getValue()))) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.getEntries().size();
    }

    public String toString(Context cx) {
        return this.encodeToString();
    }

    protected abstract BCadrTargets newInstance();

    private static ArrayList clone(ArrayList arg) {
        if (arg == null) {
            return null;
        }
        return new ArrayList(arg);
    }

    private ArrayList getEntries() {
        try {
            if (this.entries == null) {
                this.entries = new ArrayList();
                if (this.isNull()) {
                    return this.entries;
                }
                StringReader in = new StringReader(this.encoded);
                StringBuffer buf = new StringBuffer();
                boolean more = true;
                while (more) {
                    int ch = BCadrTargets.read(in, buf);
                    String key = buf.toString();
                    if (ch != 61) {
                        throw new IllegalArgumentException("Expecting '='");
                    }
                    ch = BCadrTargets.read(in, buf);
                    String value = buf.toString();
                    this.entries.add(new Entry(key, value));
                    more = ch == 44;
                }
            }
        }
        catch (IOException wtf) {
            this.error("", wtf);
        }
        return this.entries;
    }

    private static int read(Reader in, StringBuffer buf) throws IOException {
        buf.setLength(0);
        int ch = in.read();
        while (ch >= 0 && ch != 61 && ch != 44) {
            if (ch == 92) {
                ch = (char)in.read();
                switch (ch) {
                    case 117: {
                        ch = BCadrTargets.readUnicode(in);
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                }
            }
            buf.append((char)ch);
            ch = in.read();
        }
        return ch;
    }

    private static char readUnicode(Reader in) throws IOException {
        int ret = 0;
        block5: for (int i = 0; i < 4; ++i) {
            int ch = in.read();
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    ret = (ret << 4) + ch - 48;
                    continue block5;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    ret = (ret << 4) + (ch - 97) + 10;
                    continue block5;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    ret = (ret << 4) + (ch - 65) + 10;
                    continue block5;
                }
                default: {
                    throw new IOException("Illegal character in unicode escape: " + (char)ch);
                }
            }
        }
        return (char)ret;
    }

    private static void write(String s, StringBuffer out) {
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case ',': 
                case ':': 
                case '\\': {
                    out.append('\\');
                    out.append(ch);
                    continue block6;
                }
                case '\f': {
                    out.append('\\');
                    out.append('f');
                    continue block6;
                }
                case '\n': {
                    out.append('\\');
                    out.append('n');
                    continue block6;
                }
                case '\r': {
                    out.append('\\');
                    out.append('r');
                    continue block6;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        BCadrTargets.writeUnicode(ch, out);
                        continue block6;
                    }
                    out.append(ch);
                }
            }
        }
    }

    private static void writeUnicode(char ch, StringBuffer out) {
        out.append('\\');
        out.append('u');
        out.append(HEX[ch >>> 12 & 0xF]);
        out.append(HEX[ch >>> 8 & 0xF]);
        out.append(HEX[ch >>> 4 & 0xF]);
        out.append(HEX[ch & 0xF]);
    }

    static XElem x(XNs ns, String name) {
        return BCadrTargets.x(ns, name, (String)null);
    }

    static XElem x(XNs ns, String name, String text) {
        XElem ret = new XElem(ns, name);
        if (text != null) {
            ret.addText(text);
        }
        return ret;
    }

    static XElem x(XNs ns, String name, XElem child) {
        XElem ret = new XElem(ns, name);
        if (child != null) {
            ret.addContent((XContent)child);
        }
        return ret;
    }

    public static class Entry
    implements Comparable {
        private final String key;
        private final String value;

        Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public int compareTo(Object o) {
            Entry him = (Entry)o;
            int ret = this.key.compareTo(him.key);
            if (ret == 0) {
                ret = this.value.compareTo(him.value);
            }
            return ret;
        }

        public boolean equals(String key, String value) {
            if (!key.equals(this.key)) {
                return false;
            }
            return value.equals(this.value);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

