/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import com.ca.adr.util.Logging;
import com.ca.adr.util.Message;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCadrMessageQueue
extends BComponent
implements Runnable {
    public static final Property normalMessages = BCadrMessageQueue.newProperty((int)3, (int)0, null);
    public static final Property urgentMessages = BCadrMessageQueue.newProperty((int)3, (int)0, null);
    public static final Action clear = BCadrMessageQueue.newAction((int)4, null);
    public static final Action debug = BCadrMessageQueue.newAction((int)0, null);
    public static final Action urgentToNormal = BCadrMessageQueue.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCadrMessageQueue.class);
    private boolean alive = true;
    private final ArrayList normalQueue = new ArrayList();
    private final Object mutex = new Object();
    private final TreeMap normalTable = new TreeMap();
    private final ArrayList urgentQueue = new ArrayList();
    private final TreeMap urgentTable = new TreeMap();

    public int getNormalMessages() {
        return this.getInt(normalMessages);
    }

    public void setNormalMessages(int v) {
        this.setInt(normalMessages, v, null);
    }

    public int getUrgentMessages() {
        return this.getInt(urgentMessages);
    }

    public void setUrgentMessages(int v) {
        this.setInt(urgentMessages, v, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void debug() {
        this.invoke(debug, null, null);
    }

    public void urgentToNormal() {
        this.invoke(urgentToNormal, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClear() {
        Object object = this.mutex;
        synchronized (object) {
            this.normalQueue.clear();
            this.normalTable.clear();
            this.setNormalMessages(0);
            this.urgentQueue.clear();
            this.urgentTable.clear();
            this.setUrgentMessages(0);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDebug() {
        System.out.println("\nMessage queue dump:");
        Object object = this.mutex;
        synchronized (object) {
            int i;
            System.out.println("Urgent message queue:");
            int len = this.urgentQueue.size();
            for (i = 0; i < len; ++i) {
                System.out.println(this.urgentQueue.get(i));
            }
            System.out.println("Normal message queue:");
            len = this.normalQueue.size();
            for (i = 0; i < len; ++i) {
                System.out.println(this.normalQueue.get(i));
            }
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUrgentToNormal() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList tmp = new ArrayList(this.urgentQueue);
            this.urgentQueue.clear();
            this.urgentTable.clear();
            this.setUrgentMessages(0);
            for (Object o : tmp) {
                this.enqueueNormal((Message)o);
            }
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Message message) {
        Object object = this.mutex;
        synchronized (object) {
            if (message.isUrgent()) {
                this.enqueueUrgent(message);
            } else {
                this.enqueueNormal(message);
            }
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message message = null;
        while (this.alive) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.urgentQueue.size() > 0) {
                    message = (Message)this.urgentQueue.remove(0);
                }
                if (message != null) {
                    this.urgentTable.remove(message.getCoalesceKey());
                    this.setUrgentMessages(this.urgentQueue.size());
                }
                if (message == null) {
                    if (this.normalQueue.size() > 0) {
                        message = (Message)this.normalQueue.remove(0);
                    }
                    if (message != null) {
                        this.normalTable.remove(message.getCoalesceKey());
                        this.setNormalMessages(this.normalQueue.size());
                    }
                }
                if (message == null) {
                    this.mutex.notify();
                    try {
                        this.mutex.wait(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.mutex.notify();
            }
            if (message != null) {
                try {
                    if (this.alive) {
                        message.run();
                    }
                }
                catch (Throwable x) {
                    Logging.LOGGER.log(Level.SEVERE, this.toPathString(), x);
                }
                Thread.yield();
            }
            message = null;
        }
    }

    public void started() throws Exception {
        super.started();
        Thread t = new Thread((Runnable)this, this.getParent().toString(null));
        t.setDaemon(true);
        t.start();
    }

    public void stopped() throws Exception {
        this.alive = false;
        this.clear();
        super.stopped();
    }

    private void enqueueNormal(Message message) {
        if (this.urgentTable.get(message.getCoalesceKey()) != null) {
            return;
        }
        if (this.normalTable.get(message.getCoalesceKey()) != null) {
            return;
        }
        this.normalTable.put(message.getCoalesceKey(), message);
        this.normalQueue.add(message);
        this.setNormalMessages(this.normalQueue.size());
    }

    private void enqueueUrgent(Message message) {
        if (this.urgentTable.get(message.getCoalesceKey()) != null) {
            return;
        }
        this.urgentTable.put(message.getCoalesceKey(), message);
        this.urgentQueue.add(message);
        this.setUrgentMessages(this.urgentQueue.size());
    }
}

