/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.util;

import com.ca.adr.BCadrNetwork;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public abstract class BCadrDiscoveryJob
extends BJob {
    public static final Action discover = BCadrDiscoveryJob.newAction((int)16, null);
    public static final Action getResults = BCadrDiscoveryJob.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCadrDiscoveryJob.class);
    private boolean canceled = false;
    private BCadrNetwork network;
    private BComponent results;

    public void discover() {
        this.invoke(discover, null, null);
    }

    public BComponent getResults() {
        return (BComponent)this.invoke(getResults, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCadrDiscoveryJob() {
    }

    public BCadrDiscoveryJob(BCadrNetwork network) {
        this.network = network;
    }

    public void addResult(String name, BValue result) {
        if (this.results == null) {
            this.results = new BComponent();
        }
        if (result != null) {
            this.results.add(SlotPath.escape((String)name), result);
        }
    }

    public abstract void doDiscover();

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    public BComponent doGetResults() {
        BComponent ret = this.results;
        this.results = null;
        if (ret == null) {
            return new BComponent();
        }
        return ret;
    }

    public void doRun(Context cx) {
        this.canceled = false;
        this.discover();
    }

    public BCadrNetwork getNetwork() {
        return this.network;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void log(String msg) {
        this.log().message(msg);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == discover) {
            this.network.enqueue((Runnable)new Invocation((BComponent)this, discover, arg, cx));
            return null;
        }
        return super.post(action, arg, cx);
    }

    public void progress() {
        int progress = this.getProgress() + 5;
        if (progress >= 100) {
            progress = 5;
        }
        this.progress(progress);
    }

    public void startJob() {
        this.setJobState(BJobState.running);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
    }
}

