/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.report;

import com.ca.adr.message.ReportMessage;
import com.ca.adr.report.BCadrReport;
import com.ca.adr.report.BCadrReportRequest;
import java.util.ArrayList;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public abstract class BTelemetryRequest
extends BCadrReportRequest {
    public static final Property bufferSize = BTelemetryRequest.newProperty((int)3, (int)0, null);
    public static final Action reportBack = BTelemetryRequest.newAction((int)20, null);
    public static final Action updateBuffer = BTelemetryRequest.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BTelemetryRequest.class);
    private boolean canceled = false;
    private XElem oadrReport;
    private Clock.Ticket reportBackTicket;
    private MySubscriber subscriber;
    private Clock.Ticket updateBufferTicket;

    public int getBufferSize() {
        return this.getInt(bufferSize);
    }

    public void setBufferSize(int v) {
        this.setInt(bufferSize, v, null);
    }

    public void reportBack() {
        this.invoke(reportBack, null, null);
    }

    public void updateBuffer() {
        this.invoke(updateBuffer, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.subscriber = new MySubscriber();
        ArrayList reports = this.getReports();
        int i = reports.size();
        while (--i >= 0) {
            BCadrReport rpt = (BCadrReport)reports.get(i);
            BObject o = rpt.resolveSource();
            if (!(o instanceof BComponent)) continue;
            this.subscriber.subscribe((BComponent)o);
        }
        if (this.getUpdateBufferRate().getMillis() == 0L || this.getReportBackRate().getMillis() == 0L) {
            if (!this.getDevice().getEnabled()) {
                this.cancelNow();
                return;
            }
            if (!this.getEndTime().isNull()) {
                this.setEndTime(BAbsTime.NULL);
            }
            this.cancelAfterNext();
            this.doUpdateBuffer();
            this.reportBack();
            return;
        }
        BAbsTime start = this.getLastUpdate();
        if (start.isNull()) {
            start = this.getStartTime();
        }
        BAbsTime now = Clock.time();
        while (start.isBefore(now)) {
            start = start.add(this.getReportBackRate());
        }
        this.updateBufferTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)start.add(BRelTime.make((long)10L)), (BRelTime)this.getUpdateBufferRate(), (Action)updateBuffer, null);
        start = start.add(this.getReportBackRate());
        this.reportBackTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)start, (BRelTime)this.getReportBackRate(), (Action)reportBack, null);
    }

    @Override
    public void cancelAfterNext() {
        this.canceled = true;
    }

    @Override
    public void cancelNow() {
        Property p;
        if (this.updateBufferTicket != null) {
            this.updateBufferTicket.cancel();
        }
        this.updateBufferTicket = null;
        if (this.reportBackTicket != null) {
            this.reportBackTicket.cancel();
        }
        this.reportBackTicket = null;
        BComplex parent = this.getParent();
        if (parent != null && (p = this.getPropertyInParent()) != null) {
            try {
                parent.asComponent().remove(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateBuffer() {
        XElem intervals;
        BAbsTime end = this.getEndTime();
        BAbsTime now = Clock.time();
        if (!end.isNull() && now.isAfter(end)) {
            this.cancelNow();
            return;
        }
        XElem interval = ReportMessage.makeInterval(now, this);
        ArrayList reports = this.getReports();
        for (Object o : reports) {
            BComponent source;
            BCadrReport report = (BCadrReport)o;
            XElem pyld = this.encodeIntervalPayload(report, source = (BComponent)report.resolveSource());
            if (pyld == null) continue;
            interval.addContent((XContent)pyld);
        }
        BTelemetryRequest bTelemetryRequest = this;
        synchronized (bTelemetryRequest) {
            if (this.oadrReport == null) {
                this.oadrReport = ReportMessage.makeOadrReport(now, this);
            }
            intervals = this.oadrReport.elem("intervals");
            intervals.addContent((XContent)interval);
        }
        while (intervals.contentSize() > 1000) {
            intervals.removeContent(0);
        }
        this.setBufferSize(intervals.contentSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReportBack() {
        XElem rpt;
        BAbsTime end = this.getEndTime();
        if (!end.isNull() && Clock.time().isAfter(end)) {
            this.cancelNow();
            return;
        }
        BTelemetryRequest bTelemetryRequest = this;
        synchronized (bTelemetryRequest) {
            rpt = this.oadrReport;
            this.oadrReport = null;
        }
        if (rpt == null) {
            return;
        }
        this.enqueue(new ReportMessage(this, rpt));
        if (this.canceled) {
            this.cancelNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReportFailed(XElem report) {
        BTelemetryRequest bTelemetryRequest = this;
        synchronized (bTelemetryRequest) {
            this.oadrReport = report;
        }
    }

    public void stopped() throws Exception {
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
        this.subscriber = null;
        if (this.updateBufferTicket != null) {
            this.updateBufferTicket.cancel();
        }
        this.updateBufferTicket = null;
        if (this.reportBackTicket != null) {
            this.reportBackTicket.cancel();
        }
        this.reportBackTicket = null;
        super.stopped();
    }

    protected abstract XElem encodeIntervalPayload(BCadrReport var1, BComponent var2);

    private static class MySubscriber
    extends Subscriber {
        MySubscriber() {
        }

        public void event(BComponentEvent evt) {
        }
    }
}

