/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.report;

import com.ca.adr.BCadrObject;
import com.ca.adr.BOadrVen2b;
import com.ca.adr.report.BCadrReport;
import com.ca.adr.util.Csv;
import java.util.ArrayList;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BCadrReportRequest
extends BCadrObject {
    public static final Property requestId = BCadrReportRequest.newProperty((int)1, (String)"", null);
    public static final Property specifierId = BCadrReportRequest.newProperty((int)1, (String)"", null);
    public static final Property dataPoints = BCadrReportRequest.newProperty((int)1, (String)"", null);
    public static final Property startTime = BCadrReportRequest.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property endTime = BCadrReportRequest.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property updateBufferRate = BCadrReportRequest.newProperty((int)1, (BValue)BRelTime.MINUTE, null);
    public static final Property reportBackRate = BCadrReportRequest.newProperty((int)1, (BValue)BRelTime.HOUR, null);
    public static final Property lastUpdate = BCadrReportRequest.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BCadrReportRequest.class);
    private ArrayList reports;
    private BOadrVen2b ven;

    public String getRequestId() {
        return this.getString(requestId);
    }

    public void setRequestId(String v) {
        this.setString(requestId, v, null);
    }

    public String getSpecifierId() {
        return this.getString(specifierId);
    }

    public void setSpecifierId(String v) {
        this.setString(specifierId, v, null);
    }

    public String getDataPoints() {
        return this.getString(dataPoints);
    }

    public void setDataPoints(String v) {
        this.setString(dataPoints, v, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    public BRelTime getUpdateBufferRate() {
        return (BRelTime)this.get(updateBufferRate);
    }

    public void setUpdateBufferRate(BRelTime v) {
        this.set(updateBufferRate, (BValue)v, null);
    }

    public BRelTime getReportBackRate() {
        return (BRelTime)this.get(reportBackRate);
    }

    public void setReportBackRate(BRelTime v) {
        this.set(reportBackRate, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void cancelAfterNext() {
    }

    public void cancelNow() {
    }

    public BOadrVen2b getVen() {
        for (BComplex comp = this.getParent(); comp != null && this.ven == null; comp = comp.getParent()) {
            if (!(comp instanceof BOadrVen2b)) continue;
            this.ven = (BOadrVen2b)comp;
            break;
        }
        return this.ven;
    }

    public void onReportFailed(XElem report) {
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    protected ArrayList getReports() {
        if (this.reports == null) {
            ArrayList sources = Csv.readRow(this.getDataPoints(), ',', null);
            this.reports = new ArrayList(sources.size());
            int i = sources.size();
            while (--i >= 0) {
                BCadrReport report = this.getReport(SlotPath.escape((String)((String)sources.get(i))));
                if (report == null) continue;
                this.reports.add(report);
            }
        }
        return this.reports;
    }

    private BCadrReport getReport(String name) {
        return (BCadrReport)this.getVen().getReports().get(name);
    }
}

