/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.report;

import com.ca.adr.BCadrObject;
import com.ca.adr.BOadrVen2b;
import com.ca.adr.CadrConstants;
import com.ca.adr.report.BCadrReports;
import com.ca.adr.util.BCadrEventTargets;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BCadrReport
extends BCadrObject
implements BIStatus,
CadrConstants {
    public static final Property status = BCadrReport.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BCadrReport.newProperty((int)3, (String)"", null);
    public static final Property source = BCadrReport.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property program = BCadrReport.newProperty((int)0, (String)"", null);
    public static final Property resource = BCadrReport.newProperty((int)0, (BValue)BCadrEventTargets.NULL, null);
    public static final Property facets = BCadrReport.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Action refresh = BCadrReport.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCadrReport.class);
    private static final BRelTime minSamplePeriod = BRelTime.makeSeconds((int)15);
    private static final BRelTime maxSamplePeriod = BRelTime.HOUR;
    private static final BRelTime maxRptDuration = BRelTime.DAY;
    private BObject resolvedSource;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getSource() {
        return (BOrd)this.get(source);
    }

    public void setSource(BOrd v) {
        this.set(source, (BValue)v, null);
    }

    public String getProgram() {
        return this.getString(program);
    }

    public void setProgram(String v) {
        this.setString(program, v, null);
    }

    public BCadrEventTargets getResource() {
        return (BCadrEventTargets)this.get(resource);
    }

    public void setResource(BCadrEventTargets v) {
        this.set(resource, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        this.updateState();
        super.atSteadyState();
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(source)) {
                this.resolvedSource = null;
                this.updateState();
            } else if (p.equals(facets)) {
                this.updateState();
            }
        }
        super.changed(p, cx);
    }

    public void doRefresh() {
        this.resolvedSource = null;
        this.updateState();
    }

    public BOadrVen2b getVen() {
        return ((BCadrReports)this.getParent()).getVen();
    }

    public void configFailure(String message) {
        if (!this.getStatus().isFault()) {
            this.setStatus(BStatus.fault);
        }
        if (!this.getFaultCause().equals(message)) {
            this.setFaultCause(message);
        }
    }

    public void configSuccess() {
        if (!this.getStatus().isOk()) {
            this.setStatus(BStatus.ok);
        }
        if (!this.getFaultCause().equals("")) {
            this.setFaultCause("");
        }
    }

    public BIcon getIcon() {
        return icnRpt;
    }

    public BFacets getReportFacets() {
        BIHistory h;
        BFacets tmp;
        BFacets ret = this.getFacets();
        BObject o = this.resolveSource();
        if (o == null) {
            return ret;
        }
        if (o instanceof BIHistory && (tmp = (BFacets)(h = (BIHistory)o).getConfig().get("valueFacets")) != null && !tmp.isNull()) {
            return BFacets.make((BFacets)tmp, (BFacets)ret);
        }
        if (o instanceof BINumeric && (tmp = ((BINumeric)o).getNumericFacets()) != null && !tmp.isNull()) {
            return BFacets.make((BFacets)tmp, (BFacets)ret);
        }
        if (o.isComplex()) {
            BComplex c = o.asComplex();
            tmp = (BFacets)c.get("facets");
            if (tmp == null) {
                Property p = c.getPropertyInParent();
                BComplex pa = c.getParent();
                if (p != null) {
                    tmp = pa.getSlotFacets((Slot)p);
                }
            }
            if (tmp != null && !tmp.isNull()) {
                return BFacets.make((BFacets)tmp, (BFacets)ret);
            }
        }
        return ret;
    }

    public BObject resolveSource() {
        if (this.resolvedSource != null) {
            return this.resolvedSource;
        }
        try {
            this.resolvedSource = this.getSource().get((BObject)this);
        }
        catch (Exception x) {
            this.configFailure("Invalid source ord");
        }
        if (!this.validateSource(this.resolvedSource)) {
            this.resolvedSource = null;
        }
        return this.resolvedSource;
    }

    @Override
    public void started() throws Exception {
        Property p = this.getProperty("marketContext");
        if (p != null) {
            this.set("program", this.get(p));
            this.remove(p);
        }
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public BRelTime getMaxReportDuration() {
        return maxRptDuration;
    }

    public BRelTime getMaxSamplePeriod() {
        return maxSamplePeriod;
    }

    public abstract String getMetaDataID();

    public BRelTime getMinSamplePeriod() {
        return minSamplePeriod;
    }

    public abstract String getReportType();

    public abstract String getReadingType();

    public abstract String getSpecifierID();

    public abstract boolean getSampleOnChange();

    public abstract boolean hasSamplingRate();

    public boolean hasUnits() {
        return true;
    }

    protected void updateState() {
        if (this.resolveSource() == null) {
            return;
        }
        this.configSuccess();
    }

    protected boolean validateSource(BObject source) {
        return true;
    }
}

