/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.point;

import com.ca.adr.BCadrDevice;
import com.ca.adr.BCadrNetwork;
import com.ca.adr.CadrTarget;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.event.BCadrInterval;
import com.ca.adr.event.BCadrSignal;
import com.ca.adr.point.BCadrPointDeviceExt;
import com.ca.adr.util.BCadrEventState;
import com.ca.adr.util.BCadrEventTargets;
import com.ca.adr.util.BCadrSignalTargets;
import com.ca.adr.util.Csv;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.control.BIWritablePoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BCadrProxyExt
extends BProxyExt
implements CadrTarget {
    public static final Property writeValue = BCadrProxyExt.newProperty((int)7, (BValue)new BStatusString("-"), null);
    public static final Property tuningPolicyName = BCadrProxyExt.newProperty((int)7, (String)"default", null);
    public static final Property conversion = BCadrProxyExt.newProperty((int)7, (BValue)BDefaultProxyConversion.DEFAULT, null);
    public static final Property signalNames = BCadrProxyExt.newProperty((int)0x10000000, (String)"*", null);
    public static final Property signalTypes = BCadrProxyExt.newProperty((int)0x10000000, (String)"*", null);
    public static final Property programs = BCadrProxyExt.newProperty((int)0x10000000, (String)"*", null);
    public static final Property eventTargets = BCadrProxyExt.newProperty((int)0x10000000, (BValue)BCadrEventTargets.NULL, null);
    public static final Property signalTargets = BCadrProxyExt.newProperty((int)0x10000000, (BValue)BCadrSignalTargets.NULL, null);
    public static final Property signal = BCadrProxyExt.newProperty((int)65, (BValue)BOrd.NULL, null);
    public static final Property eventId = BCadrProxyExt.newProperty((int)65, (String)"", null);
    public static final Property rampStart = BCadrProxyExt.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property eventStart = BCadrProxyExt.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property eventEnd = BCadrProxyExt.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property recoveryEnd = BCadrProxyExt.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property eventState = BCadrProxyExt.newProperty((int)65, (BValue)BCadrEventState.idle, null);
    public static final Property testEvent = BCadrProxyExt.newProperty((int)65, (boolean)false, null);
    public static final Property nextIntervalStart = BCadrProxyExt.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Action is2b = BCadrProxyExt.newAction((int)4, null);
    public static final Action optOut = BCadrProxyExt.newAction((int)0, null);
    public static final Action optIn = BCadrProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCadrProxyExt.class);
    private BCadrDevice device = null;
    private BCadrSignal signalRef;
    private Target tgMarkets;
    private Target tgSignalNames;
    private Target tgSignalTypes;

    public BStatusValue getWriteValue() {
        return (BStatusValue)this.get(writeValue);
    }

    public void setWriteValue(BStatusValue v) {
        this.set(writeValue, (BValue)v, null);
    }

    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String v) {
        this.setString(tuningPolicyName, v, null);
    }

    public BProxyConversion getConversion() {
        return (BProxyConversion)this.get(conversion);
    }

    public void setConversion(BProxyConversion v) {
        this.set(conversion, (BValue)v, null);
    }

    public String getSignalNames() {
        return this.getString(signalNames);
    }

    public void setSignalNames(String v) {
        this.setString(signalNames, v, null);
    }

    public String getSignalTypes() {
        return this.getString(signalTypes);
    }

    public void setSignalTypes(String v) {
        this.setString(signalTypes, v, null);
    }

    public String getPrograms() {
        return this.getString(programs);
    }

    public void setPrograms(String v) {
        this.setString(programs, v, null);
    }

    public BCadrEventTargets getEventTargets() {
        return (BCadrEventTargets)this.get(eventTargets);
    }

    public void setEventTargets(BCadrEventTargets v) {
        this.set(eventTargets, (BValue)v, null);
    }

    public BCadrSignalTargets getSignalTargets() {
        return (BCadrSignalTargets)this.get(signalTargets);
    }

    public void setSignalTargets(BCadrSignalTargets v) {
        this.set(signalTargets, (BValue)v, null);
    }

    public BOrd getSignal() {
        return (BOrd)this.get(signal);
    }

    public void setSignal(BOrd v) {
        this.set(signal, (BValue)v, null);
    }

    public String getEventId() {
        return this.getString(eventId);
    }

    public void setEventId(String v) {
        this.setString(eventId, v, null);
    }

    public BAbsTime getRampStart() {
        return (BAbsTime)this.get(rampStart);
    }

    public void setRampStart(BAbsTime v) {
        this.set(rampStart, (BValue)v, null);
    }

    public BAbsTime getEventStart() {
        return (BAbsTime)this.get(eventStart);
    }

    public void setEventStart(BAbsTime v) {
        this.set(eventStart, (BValue)v, null);
    }

    public BAbsTime getEventEnd() {
        return (BAbsTime)this.get(eventEnd);
    }

    public void setEventEnd(BAbsTime v) {
        this.set(eventEnd, (BValue)v, null);
    }

    public BAbsTime getRecoveryEnd() {
        return (BAbsTime)this.get(recoveryEnd);
    }

    public void setRecoveryEnd(BAbsTime v) {
        this.set(recoveryEnd, (BValue)v, null);
    }

    public BCadrEventState getEventState() {
        return (BCadrEventState)this.get(eventState);
    }

    public void setEventState(BCadrEventState v) {
        this.set(eventState, (BValue)v, null);
    }

    public boolean getTestEvent() {
        return this.getBoolean(testEvent);
    }

    public void setTestEvent(boolean v) {
        this.setBoolean(testEvent, v, null);
    }

    public BAbsTime getNextIntervalStart() {
        return (BAbsTime)this.get(nextIntervalStart);
    }

    public void setNextIntervalStart(BAbsTime v) {
        this.set(nextIntervalStart, (BValue)v, null);
    }

    public BBoolean is2b() {
        return (BBoolean)this.invoke(is2b, null, null);
    }

    public void optOut() {
        this.invoke(optOut, null, null);
    }

    public void optIn() {
        this.invoke(optIn, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(signal)) {
                this.signalRef = null;
            } else if (p.equals(signalNames)) {
                this.tgSignalNames = null;
            } else if (p.equals(signalTypes)) {
                this.tgSignalTypes = null;
            } else if (p.equals(programs)) {
                this.tgMarkets = null;
            }
            if (Flags.isUserDefined1((BComplex)this, (Slot)p)) {
                this.getCadrDevice().scheduleUpdate(System.currentTimeMillis() + 1000L);
            }
        }
        super.changed(p, cx);
    }

    public BBoolean doIs2b() {
        return BBoolean.make((boolean)this.getCadrDevice().is2b());
    }

    public void doOptIn() {
        BCadrSignal sig = this.resolveSignal();
        if (sig == null) {
            return;
        }
        BCadrEvent evt = sig.getEvent();
        if (evt == null) {
            return;
        }
        if (!evt.getOptIn()) {
            evt.setOptIn(true);
        }
    }

    public void doOptOut() {
        BCadrSignal sig = this.resolveSignal();
        if (sig == null) {
            return;
        }
        BCadrEvent evt = sig.getEvent();
        if (evt == null) {
            return;
        }
        if (evt.getOptIn()) {
            evt.setOptIn(false);
        }
    }

    public Type getDeviceExtType() {
        return BCadrPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParent() instanceof BIWritablePoint) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public BCadrDevice getCadrDevice() {
        if (this.device == null) {
            for (BCadrProxyExt cur = this; cur != null; cur = cur.getParent()) {
                if (!(cur instanceof BCadrDevice)) continue;
                this.device = (BCadrDevice)((Object)cur);
                break;
            }
        }
        return this.device;
    }

    public BCadrNetwork getCadrNetwork() {
        return this.getCadrDevice().getCadrNetwork();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getCadrNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void readNull() {
        BStatusValue cur = this.getParentPoint().getOutStatusValue();
        if (cur.getStatus().isNull() && this.getReadValue().equivalent((Object)cur)) {
            return;
        }
        this.readOk(this.makeValue(0.0, BStatus.nullStatus));
    }

    public void readOk(double val) {
        BStatusValue cur = this.getParentPoint().getOutStatusValue();
        BStatusValue rv = this.getReadValue();
        if (cur instanceof BINumeric) {
            if (cur.getStatus().isOk() && cur.equivalent((Object)rv) && ((BINumeric)cur).getNumeric() == val) {
                return;
            }
            this.readOk((BStatusValue)new BStatusNumeric(val, BStatus.ok));
        } else if (cur instanceof BIBoolean) {
            boolean bool;
            boolean bl = bool = val != 0.0;
            if (cur.getStatus().isOk() && cur.equivalent((Object)rv) && ((BIBoolean)cur).getBoolean() == bool) {
                return;
            }
            this.readOk((BStatusValue)new BStatusBoolean(bool, BStatus.ok));
        } else if (cur instanceof BIEnum) {
            int ord = (int)val;
            if (cur.getStatus().isOk() && cur.equivalent((Object)rv) && ((BIEnum)cur).getEnum().getOrdinal() == ord) {
                return;
            }
            this.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)val)), BStatus.ok));
        } else {
            String str = String.valueOf(val);
            if (cur.getStatus().isOk() && cur.equivalent((Object)rv) && cur.getValueValue().toString().equals(str)) {
                return;
            }
            this.readOk((BStatusValue)new BStatusString(str, BStatus.ok));
        }
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public void setStale(boolean stale, Context cx) {
    }

    public void started() throws Exception {
        Property p = this.getProperty("marketContexts");
        if (p != null) {
            this.set("programs", this.get(p));
            this.remove(p);
        }
        this.getCadrDevice().addTarget(this);
        if (this.getNextIntervalValue() == null) {
            this.setNextIntervalValue(this.makeValue(0.0, BStatus.nullStatus));
        }
        super.started();
    }

    public void stopped() throws Exception {
        this.getCadrDevice().removeTarget(this);
        this.device = null;
        super.stopped();
    }

    public boolean write(Context cx) {
        return false;
    }

    @Override
    public boolean accepts(BCadrEventTargets arg) {
        return this.getEventTargets().matches(arg);
    }

    @Override
    public boolean accepts(BCadrSignalTargets arg) {
        return this.getSignalTargets().matches(arg);
    }

    @Override
    public boolean acceptsMarketContext(String arg) {
        if (this.tgMarkets == null) {
            this.tgMarkets = new Target(this.getPrograms());
        }
        return this.tgMarkets.matches(arg);
    }

    @Override
    public boolean acceptsSignal(String name, String type) {
        if (this.tgSignalNames == null) {
            this.tgSignalNames = new Target(this.getSignalNames());
        }
        if (!this.tgSignalNames.matches(name)) {
            return false;
        }
        if (this.tgSignalTypes == null) {
            this.tgSignalTypes = new Target(this.getSignalTypes());
        }
        return this.tgSignalTypes.matches(type);
    }

    @Override
    public void cadrUpdate(BCadrSignal signal) {
        BUnit su;
        long time;
        BCadrSignal cur = this.resolveSignal();
        if (signal == null) {
            signal = cur;
        }
        if (signal != cur) {
            this.setSignal(signal.getSlotPathOrd());
        }
        if (signal == null) {
            if (!this.getEventState().equivalent((Object)BCadrEventState.idle)) {
                this.setEventState(BCadrEventState.idle);
            }
            if (this.getEventId().length() > 0) {
                this.setEventId("");
            }
            if (!this.getSignal().isNull()) {
                this.setSignal(BOrd.NULL);
            }
            if (!this.getNextIntervalStart().isNull()) {
                this.setNextIntervalStart(BAbsTime.NULL);
            }
            if (!this.getNextIntervalValue().isNull()) {
                this.setNextIntervalValue(this.makeValue(0.0, BStatus.nullStatus));
            }
            if (this.getTestEvent()) {
                this.setTestEvent(false);
            }
            this.readNull();
            return;
        }
        BCadrEvent evt = signal.getEvent();
        BCadrEventState state = evt.getEventState();
        if (!state.equivalent((Object)this.getEventState())) {
            this.setEventState(state);
        }
        if (!this.getEventId().equals(evt.getEventId())) {
            this.setEventId(evt.getEventId());
        }
        if (this.getTestEvent() != evt.getTestEvent()) {
            this.setTestEvent(evt.getTestEvent());
        }
        if ((time = evt.actualRampStart()) < 0L) {
            if (!this.getRampStart().isNull()) {
                this.setRampStart(BAbsTime.NULL);
            }
        } else if (time != this.getRampStart().getMillis()) {
            this.setRampStart(BAbsTime.make((long)time));
        }
        if ((time = evt.actualEventStart()) != this.getEventStart().getMillis()) {
            this.setEventStart(BAbsTime.make((long)time));
        }
        if ((time = evt.actualEventEnd()) != this.getEventEnd().getMillis()) {
            this.setEventEnd(BAbsTime.make((long)time));
        }
        if ((time = evt.actualRecoveryEnd()) != this.getRecoveryEnd().getMillis()) {
            this.setRecoveryEnd(BAbsTime.make((long)time));
        }
        if (!(su = signal.getUnit()).isNull()) {
            BFacets f = this.getDeviceFacets();
            BUnit u = (BUnit)f.get("units");
            if (u != su) {
                f = BFacets.make((BFacets)f, (String)"units", (BIDataValue)su);
                this.setDeviceFacets(f);
            }
            if ((u = (BUnit)(f = this.getParentPoint().getFacets()).get("units")) == null || u.isNull()) {
                f = BFacets.make((BFacets)f, (String)"units", (BIDataValue)su);
                this.getParentPoint().setFacets(f);
            }
        }
        boolean nextIsNull = true;
        if (state.isFinished()) {
            this.readNull();
        } else {
            BAbsTime now = BAbsTime.now();
            BCadrInterval ivl = signal.activeInterval(evt.actualEventStart(), now.getMillis());
            if (ivl == null) {
                this.readNull();
            } else {
                this.readOk(ivl.getPayload());
            }
            long ms = signal.nextIntervalStart(evt.actualEventStart(), now.getMillis());
            if (ms > 0L && (ivl = signal.activeInterval(evt.actualEventStart(), ms)) != null) {
                nextIsNull = false;
                this.setNextIntervalStart(BAbsTime.make((long)ms));
                this.setNextIntervalValue(this.makeValue(ivl.getPayload(), BStatus.ok));
            }
        }
        if (nextIsNull) {
            if (!this.getNextIntervalStart().isNull()) {
                this.setNextIntervalStart(BAbsTime.NULL);
            }
            if (!this.getNextIntervalValue().isNull()) {
                this.setNextIntervalValue(this.makeValue(0.0, BStatus.nullStatus));
            }
        }
    }

    BStatusValue getNextIntervalValue() {
        BStatusValue ret = (BStatusValue)this.get("nextIntervalValue");
        if (ret == null) {
            return this.makeValue(0.0, BStatus.nullStatus);
        }
        return ret;
    }

    void setNextIntervalValue(BStatusValue value) {
        if (this.get("nextIntervalValue") == null) {
            Property prop = this.add("nextIntervalValue", (BValue)value, 65);
            this.setDisplayName(prop, BFormat.make((String)"Next Interval Value"), null);
        } else {
            this.set("nextIntervalValue", (BValue)value);
        }
    }

    private static BFacets makeTimeFacets() {
        BFacets f = BFacets.NULL;
        f = BFacets.make((BFacets)f, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
        f = BFacets.make((BFacets)f, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
        return f;
    }

    private BStatusValue makeValue(double val, BStatus status) {
        BStatusValue cur = this.getParentPoint().getOutStatusValue();
        if (cur instanceof BINumeric) {
            return new BStatusNumeric(val, status);
        }
        if (cur instanceof BIBoolean) {
            return new BStatusBoolean(val != 0.0, status);
        }
        if (cur instanceof BIEnum) {
            return new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)val)), status);
        }
        return new BStatusString(String.valueOf(val), status);
    }

    private BCadrSignal resolveSignal() {
        if (this.signalRef == null) {
            BOrd o = this.getSignal();
            if (o.isNull()) {
                return null;
            }
            try {
                this.signalRef = (BCadrSignal)this.getSignal().get((BObject)this);
            }
            catch (Exception x) {
                this.setSignal(BOrd.NULL);
            }
        }
        return this.signalRef;
    }

    private static class Target {
        private boolean wild = false;
        private Set set;
        private String val;

        Target(String s) {
            s = s.toUpperCase();
            if (s.length() == 0 || s.equals("*")) {
                this.wild = true;
            } else if (s.indexOf(44) < 0) {
                this.val = s;
            } else {
                this.set = new TreeSet();
                this.set.addAll(Csv.readRow(s, ',', null));
            }
        }

        public boolean matches(String arg) {
            if (this.wild) {
                return true;
            }
            if (arg == null || arg.length() == 0) {
                return false;
            }
            arg = arg.toUpperCase();
            if (this.val != null) {
                return this.val.equals(arg);
            }
            return this.set.contains(arg);
        }
    }
}

