/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.message.OadrMessage;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class RequestEventMessage
extends OadrMessage {
    public RequestEventMessage(BCadrDevice device) {
        super(device);
    }

    @Override
    protected void execute() throws Exception {
        if (this.device.is2b()) {
            try {
                XElem elem = RequestEventMessage.makeRequestEvent2b(this.device);
                elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiEvent", elem);
                this.processOadrResponse(elem);
            }
            catch (Exception x) {
                this.error(this.device.toPathString(), x);
            }
        } else {
            XElem elem = RequestEventMessage.makeRequestEvent2a(this.device);
            elem = this.device.postXml("/OpenADR2/Simple/EiEvent", elem);
            this.processDistributeEvent(elem);
        }
    }

    private static XElem makeRequestEvent2a(BCadrDevice ven) {
        XElem msg = new XElem(nsOadr2a, "oadrRequestEvent");
        msg.defineNs(nsOadr2a);
        msg.defineNs(nsEi);
        msg.defineNs(nsEmix);
        msg.defineNs(nsPyld);
        XElem re = RequestEventMessage.x(nsPyld, "eiRequestEvent");
        re.addContent((XContent)RequestEventMessage.x(nsPyld, "requestID", ven.getHandle() + ""));
        re.addContent((XContent)RequestEventMessage.x(nsEi, "venID", ven.getVenId()));
        msg.addContent((XContent)re);
        return msg;
    }

    private static XElem makeRequestEvent2b(BCadrDevice ven) {
        XElem msg = new XElem(nsOadr2b, "oadrRequestEvent");
        msg.addAttr(nsEi, "schemaVersion", "2.0b");
        XElem re = RequestEventMessage.x(nsPyld, "eiRequestEvent");
        re.addContent((XContent)RequestEventMessage.x(nsPyld, "requestID", ven.getHandle() + ""));
        if (ven.getVenId().trim().length() > 0) {
            re.addContent((XContent)RequestEventMessage.x(nsEi, "venID", ven.getVenId()));
        }
        msg.addContent((XContent)re);
        return RequestEventMessage.makeMessage(msg);
    }
}

