/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.message.OadrMessage;
import com.ca.adr.report.BCadrReport;
import com.ca.adr.report.BCadrReportRequest;
import com.ca.adr.report.BTelemetryStatusReport;
import com.ca.adr.report.BTelemetryUsageRequest;
import com.ca.adr.util.Duration;
import javax.baja.naming.SlotPath;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class ReportMessage
extends OadrMessage {
    protected final XElem oadrReport;
    protected final BCadrReportRequest request;

    public ReportMessage(BCadrReportRequest request, XElem oadrReport) {
        super(request.getVen());
        this.request = request;
        this.oadrReport = oadrReport;
    }

    public static XElem makeOadrReport(BAbsTime ts, BCadrReportRequest req) {
        XElem oadrReport = new XElem(nsOadr2b, "oadrReport");
        oadrReport.addContent((XContent)ReportMessage.x(nsXcal, "dtstart", ReportMessage.x(nsXcal, "date-time", ts.encodeToString())));
        if (req instanceof BTelemetryUsageRequest) {
            String rate = Duration.make(req.getReportBackRate()).toString();
            oadrReport.addContent((XContent)ReportMessage.x(nsXcal, "duration", ReportMessage.x(nsXcal, "duration", rate)));
        }
        XElem intervals = new XElem(nsStrm, "intervals");
        oadrReport.addContent((XContent)intervals);
        return oadrReport;
    }

    public static XElem makeInterval(BAbsTime ts, BCadrReportRequest req) {
        XElem interval = new XElem(nsEi, "interval");
        interval.addContent((XContent)ReportMessage.x(nsXcal, "dtstart", ReportMessage.x(nsXcal, "date-time", ts.encodeToString())));
        if (req instanceof BTelemetryUsageRequest) {
            String rate = Duration.make(req.getUpdateBufferRate()).toString();
            interval.addContent((XContent)ReportMessage.x(nsXcal, "duration", ReportMessage.x(nsXcal, "duration", rate)));
        }
        return interval;
    }

    public static XElem makeStatusPayload(BCadrReportRequest req, BCadrReport rpt, BComponent dataSource) {
        XElem reportPayload = ReportMessage.makePayload(req, rpt, dataSource);
        XElem oprs = ReportMessage.x(nsOadr2b, "oadrPayloadResourceStatus");
        reportPayload.addContent((XContent)oprs);
        BStatus status = BStatus.ok;
        if (dataSource instanceof BIStatus) {
            status = ((BIStatus)dataSource).getStatus();
        }
        boolean online = !status.isDisabled() && !status.isDown();
        oprs.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrOnline", online + ""));
        oprs.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrManualOverride", status.isOverridden() + ""));
        oprs.addContent((XContent)ReportMessage.makeControlState(req, rpt, dataSource));
        return reportPayload;
    }

    public static XElem makeUsagePayload(BCadrReportRequest req, BCadrReport rpt, BComponent dataSource) {
        String val;
        if (dataSource instanceof BINumeric) {
            BINumeric num = (BINumeric)dataSource;
            BFacets facets = BFacets.make((BFacets)num.getNumericFacets(), (BFacets)rpt.getFacets());
            val = String.valueOf(ReportMessage.applyPrecision(num, facets));
        } else if (dataSource instanceof BIBoolean) {
            BIBoolean bool = (BIBoolean)dataSource;
            val = bool.getBoolean() ? "1" : "0";
        } else if (dataSource instanceof BIEnum) {
            BIEnum e = (BIEnum)dataSource;
            val = String.valueOf(e.getEnum().getOrdinal());
        } else {
            try {
                val = String.valueOf(Double.parseDouble(dataSource.toString(null)));
            }
            catch (Exception x) {
                val = "0";
            }
        }
        XElem reportPayload = ReportMessage.makePayload(req, rpt, dataSource);
        reportPayload.addContent((XContent)ReportMessage.x(nsEi, "payloadFloat", ReportMessage.x(nsEi, "value", val)));
        return reportPayload;
    }

    public static double applyPrecision(BINumeric val, BFacets facets) {
        double value = val.getNumeric();
        if (facets == null || facets.isNull()) {
            return value;
        }
        int precision = facets.geti("precision", -1);
        if (precision < 0) {
            return value;
        }
        if (precision == 0) {
            return Math.round(value);
        }
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    @Override
    protected void execute() throws Exception {
        XElem update = new XElem(nsOadr2b, "oadrUpdateReport");
        OadrMessage.addSchemaVersion(update);
        update.addContent((XContent)ReportMessage.x(nsPyld, "requestID", this.request.getRequestId()));
        update.addContent((XContent)ReportMessage.x(nsEi, "venID", this.getDevice().getVenId()));
        update.addContent((XContent)this.oadrReport);
        this.oadrReport.addContent((XContent)ReportMessage.x(nsEi, "eiReportID", this.request.getHandleOrd().toString(null)));
        this.oadrReport.addContent((XContent)ReportMessage.x(nsEi, "reportRequestID", this.request.getRequestId()));
        this.oadrReport.addContent((XContent)ReportMessage.x(nsEi, "reportSpecifierID", this.request.getSpecifierId()));
        this.oadrReport.addContent((XContent)ReportMessage.x(nsEi, "reportName", this.request.getSpecifierId()));
        this.oadrReport.addContent((XContent)ReportMessage.x(nsEi, "createdDateTime", Clock.time().encodeToString()));
        XElem elem = ReportMessage.makeMessage(update);
        elem = this.getDevice().postXml("/OpenADR2/Simple/2.0b/EiReport", elem);
        try {
            this.processOadrResponse(elem);
            this.request.setLastUpdate(BAbsTime.now());
        }
        catch (Exception x) {
            this.request.cancelNow();
            this.error(this.request.getRequestId(), x);
        }
    }

    protected static XElem makeControlState(BCadrReportRequest req, BCadrReport rpt, BComponent source) {
        BTelemetryStatusReport report = (BTelemetryStatusReport)rpt;
        XElem stpt = ReportMessage.x(nsOadr2b, report.getLoadControlState().getTag());
        if (source instanceof BINumeric) {
            BINumeric num = (BINumeric)source;
            stpt.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrCurrent", num.getNumeric() + ""));
        } else if (source instanceof BIBoolean) {
            BIBoolean bool = (BIBoolean)source;
            if (bool.getBoolean()) {
                stpt.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrCurrent", "1"));
            } else {
                stpt.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrCurrent", "0"));
            }
        } else if (source instanceof BIEnum) {
            BIEnum e = (BIEnum)source;
            stpt.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrCurrent", e.getEnum().getOrdinal() + ""));
        }
        return ReportMessage.x(nsOadr2b, "oadrLoadControlState", stpt);
    }

    protected static XElem makePayload(BCadrReportRequest req, BCadrReport rpt, BComponent dataSource) {
        String rid = SlotPath.unescape((String)rpt.getName());
        XElem reportPayload = ReportMessage.x(nsOadr2b, "oadrReportPayload");
        reportPayload.addContent((XContent)ReportMessage.x(nsEi, "rID", rid));
        reportPayload.addContent((XContent)ReportMessage.x(nsOadr2b, "oadrDataQuality", ReportMessage.toDataQuality((BObject)dataSource)));
        return reportPayload;
    }

    @Override
    protected void onMessageFailed() {
        this.request.onReportFailed(this.oadrReport);
    }
}

