/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.message.OadrMessage;
import com.ca.adr.report.BCadrReport;
import com.ca.adr.report.BCadrReports;
import com.ca.adr.util.Duration;
import java.util.HashMap;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.units.BUnit;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class RegisterReportsMessage
extends OadrMessage {
    static final BUnit w = BUnit.getUnit((String)"watt");
    static final BUnit wh = BUnit.getUnit((String)"watt hour");
    static final BUnit kw = BUnit.getUnit((String)"kilowatt");
    static final BUnit kwh = BUnit.getUnit((String)"kilowatt hour");
    static final BUnit mw = BUnit.getUnit((String)"megawatt");
    static final BUnit mwh = BUnit.getUnit((String)"megawatt hour");
    private String reqId;

    public RegisterReportsMessage(BCadrDevice device, String reqId) {
        super(device);
        this.reqId = reqId;
    }

    @Override
    protected void execute() throws Exception {
        if (this.reqId == null) {
            this.reqId = this.device.getHandle().toString();
        }
        this.device.cancelReports();
        XElem[] rpts = this.encodeMetaDataReports(this.reqId);
        XElem elem = RegisterReportsMessage.makeRegisterReport(this.reqId, this.device, rpts);
        elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiReport", elem);
        this.processOadrResponse(elem);
    }

    XElem[] encodeMetaDataReports(String requestId) {
        XElem metaDataRpt;
        BCadrReports obj = this.device.getReports();
        BCadrReport[] rpts = (BCadrReport[])obj.getChildren(BCadrReport.class);
        if (rpts == null || rpts.length == 0) {
            return null;
        }
        if (requestId == null) {
            requestId = "0";
        }
        HashMap<String, XElem> reports = new HashMap<String, XElem>();
        HashMap<String, BCadrReport> protos = new HashMap<String, BCadrReport>();
        for (BCadrReport bCadrReport : rpts) {
            if (!bCadrReport.getStatus().isOk()) continue;
            metaDataRpt = this.encodeOadrReportBegin(bCadrReport);
            metaDataRpt.addContent((XContent)this.encodeDescription(bCadrReport));
            reports.put(bCadrReport.getName(), metaDataRpt);
            protos.put(bCadrReport.getName(), bCadrReport);
        }
        for (BCadrReport rpt : rpts) {
            metaDataRpt = (XElem)reports.get(rpt.getName());
            BCadrReport proto = (BCadrReport)protos.get(rpt.getName());
            this.encodeOadrReportEnd(requestId, proto, metaDataRpt);
        }
        if (reports.size() == 0) {
            return null;
        }
        XElem[] ret = new XElem[reports.size()];
        reports.values().toArray(ret);
        return ret;
    }

    private XElem encodeDescription(BCadrReport rpt) {
        XElem ret = RegisterReportsMessage.x(nsOadr2b, "oadrReportDescription");
        ret.addContent((XContent)RegisterReportsMessage.x(nsEi, "rID", SlotPath.unescape((String)rpt.getName())));
        if (rpt.getResource().size() > 0) {
            XElem rds = RegisterReportsMessage.x(nsEi, "reportDataSource");
            ret.addContent((XContent)rds);
            rpt.getResource().encodeXml(rds);
        }
        ret.addContent((XContent)RegisterReportsMessage.x(nsEi, "reportType", rpt.getReportType()));
        if (rpt.hasUnits()) {
            this.encodeUnits(rpt, ret);
        }
        ret.addContent((XContent)RegisterReportsMessage.x(nsEi, "readingType", rpt.getReadingType()));
        if (rpt.getProgram().length() > 0) {
            ret.addContent((XContent)RegisterReportsMessage.x(nsEmix, "marketContext", rpt.getProgram()));
        }
        if (rpt.hasSamplingRate()) {
            XElem rate = RegisterReportsMessage.x(nsOadr2b, "oadrSamplingRate");
            BRelTime rt = rpt.getMinSamplePeriod();
            if (rt != null) {
                rate.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "oadrMinPeriod", Duration.make(rt) + ""));
            }
            if ((rt = rpt.getMaxSamplePeriod()) != null) {
                rate.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "oadrMaxPeriod", Duration.make(rt) + ""));
            }
            rate.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "oadrOnChange", rpt.getSampleOnChange() + ""));
            ret.addContent((XContent)rate);
        }
        return ret;
    }

    private XElem encodeOadrReportBegin(BCadrReport proto) {
        XElem oadrReport = RegisterReportsMessage.x(nsOadr2b, "oadrReport");
        oadrReport.addContent((XContent)RegisterReportsMessage.x(nsXcal, "duration", RegisterReportsMessage.x(nsXcal, "duration", Duration.make(proto.getMaxReportDuration()) + "")));
        return oadrReport;
    }

    private void encodeOadrReportEnd(String requestId, BCadrReport proto, XElem oadrReport) {
        oadrReport.addContent((XContent)RegisterReportsMessage.x(nsEi, "reportRequestID", requestId));
        oadrReport.addContent((XContent)RegisterReportsMessage.x(nsEi, "reportSpecifierID", proto.getSpecifierID()));
        oadrReport.addContent((XContent)RegisterReportsMessage.x(nsEi, "reportName", proto.getMetaDataID()));
        oadrReport.addContent((XContent)RegisterReportsMessage.x(nsEi, "createdDateTime", Clock.time().encodeToString()));
    }

    private void encodeUnits(BCadrReport rpt, XElem oadrRptDesc) {
        BObject source = rpt.resolveSource();
        BFacets f = rpt.getReportFacets();
        if (source instanceof BINumeric) {
            BUnit units = (BUnit)f.get("units");
            if (RegisterReportsMessage.isPower(units)) {
                oadrRptDesc.addContent((XContent)RegisterReportsMessage.opt(RegisterReportsMessage.x(nsPower, "powerReal").addContent((XContent)RegisterReportsMessage.x(nsPower, "itemDescription", "RealPower")).addContent((XContent)RegisterReportsMessage.x(nsPower, "itemUnits", "W")), this.getScaleCode(units)));
            } else if (RegisterReportsMessage.isEnergy(units)) {
                oadrRptDesc.addContent((XContent)RegisterReportsMessage.opt(RegisterReportsMessage.x(nsPower, "energyReal").addContent((XContent)RegisterReportsMessage.x(nsPower, "itemDescription", "RealEnergy")).addContent((XContent)RegisterReportsMessage.x(nsPower, "itemUnits", "Wh")), this.getScaleCode(units)));
            } else {
                BObject obj = f.get("pulseCount");
                if (obj != null) {
                    oadrRptDesc.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "pulseCount").addContent((XContent)RegisterReportsMessage.x(nsPower, "itemDescription", "pulse count")).addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "pulseFactor", obj.toString(null))));
                } else if (units != null) {
                    oadrRptDesc.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "customUnit").addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemDescription", units.getUnitName())).addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemUnits", units.getSymbol())).addContent((XContent)RegisterReportsMessage.x(nsScale, "siScaleCode", "none")));
                } else {
                    oadrRptDesc.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "customUnit").addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemDescription", "None")).addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemUnits", "")).addContent((XContent)RegisterReportsMessage.x(nsScale, "siScaleCode", "none")));
                }
            }
        } else if (source instanceof BIBoolean) {
            String name = source instanceof BComplex ? source.asComplex().getDisplayName(null) : "Boolean";
            String trueText = f.gets("trueText", "ON");
            String falseText = f.gets("falseText", "OFF");
            StringBuilder buf = new StringBuilder();
            buf.append("0=").append(falseText);
            buf.append(",1=").append(trueText);
            oadrRptDesc.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "customUnit").addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemDescription", name)).addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemUnits", buf.toString())).addContent((XContent)RegisterReportsMessage.x(nsScale, "siScaleCode", "none")));
        } else if (source instanceof BIEnum) {
            String name = source instanceof BComplex ? source.asComplex().getDisplayName(null) : "Enum";
            BEnumRange range = (BEnumRange)f.get("range");
            if (range == null) {
                BIEnum e = (BIEnum)source;
                range = e.getEnum().getRange();
            }
            int[] ordinals = range.getOrdinals();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < ordinals.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(i).append('=').append(range.getTag(ordinals[i]));
            }
            oadrRptDesc.addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "customUnit").addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemDescription", name)).addContent((XContent)RegisterReportsMessage.x(nsOadr2b, "itemUnits", buf.toString())).addContent((XContent)RegisterReportsMessage.x(nsScale, "siScaleCode", "none")));
        }
    }

    private XElem getScaleCode(BUnit u) {
        if (u == kwh || u == kw) {
            return RegisterReportsMessage.x(nsScale, "siScaleCode", "k");
        }
        if (u == mwh || u == mw) {
            return RegisterReportsMessage.x(nsScale, "siScaleCode", "M");
        }
        return null;
    }

    private static boolean isEnergy(BUnit u) {
        if (u == null) {
            return false;
        }
        return u == wh || u == kwh || u == mwh;
    }

    private static boolean isPower(BUnit u) {
        if (u == null) {
            return false;
        }
        return u == w || u == kw || u == mw;
    }

    private static XElem makeRegisterReport(String reqId, BCadrDevice ven, XElem[] reports) {
        if (reqId == null) {
            reqId = ven.getHandle().toString();
        }
        XElem msg = new XElem(nsOadr2b, "oadrRegisterReport");
        msg.addAttr(nsEi, "schemaVersion", "2.0b");
        msg.addContent((XContent)RegisterReportsMessage.x(nsEi, "venID", ven.getVenId()));
        msg.addContent((XContent)RegisterReportsMessage.x(nsPyld, "requestID", reqId));
        if (reports != null) {
            for (XElem report : reports) {
                msg.addContent((XContent)report);
            }
        }
        return RegisterReportsMessage.makeMessage(msg);
    }
}

