/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.message.OadrMessage;
import com.ca.adr.point.BCadrPointDiscoveryJob;
import com.ca.adr.point.BCadrPointDiscoveryResult;
import com.ca.adr.util.BCadrSimpleLevel;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.units.BUnit;

public class PointDiscoveryMessage
extends OadrMessage {
    static final BFacets dollar = BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"dollar"));
    static final BFacets simpleRange = BFacets.make((String)"range", (BIDataValue)BCadrSimpleLevel.normal.getRange());
    private final BCadrPointDiscoveryJob job;

    public PointDiscoveryMessage(BCadrDevice device, BCadrPointDiscoveryJob job) {
        super(device);
        this.job = job;
    }

    @Override
    public void run() {
        this.job.addResult("Simple", (BValue)this.make("*", "*", simpleRange));
        if (this.device.is2b()) {
            this.job.addResult("Elec Price", (BValue)this.make("ELECTRICITY_PRICE", "price"));
            this.job.addResult("Elec Price Relative", (BValue)this.make("ELECTRICITY_PRICE", "priceRelative"));
            this.job.addResult("Elec Price Multiplier", (BValue)this.make("ELECTRICITY_PRICE", "priceMultiplier"));
            this.job.addResult("Energy Price", (BValue)this.make("ENERGY_PRICE", "price"));
            this.job.addResult("Energy Price Relative", (BValue)this.make("ENERGY_PRICE", "priceRelative"));
            this.job.addResult("Energy Price Multiplier", (BValue)this.make("ENERGY_PRICE", "priceMultiplier"));
            this.job.addResult("Demand Charge", (BValue)this.make("DEMAND_CHARGE", "price"));
            this.job.addResult("Demand Charge Relative", (BValue)this.make("DEMAND_CHARGE", "priceRelative"));
            this.job.addResult("Demand Charge Multiplier", (BValue)this.make("DEMAND_CHARGE", "priceMultiplier"));
            this.job.addResult("Load Dispatch Delta", (BValue)this.make("LOAD_DISPATCH", "delta"));
            this.job.addResult("Load Dispatch Level", (BValue)this.make("LOAD_DISPATCH", "level"));
            this.job.addResult("Load Dispatch Multiplier", (BValue)this.make("LOAD_DISPATCH", "multiplier"));
            this.job.addResult("Load Dispatch Stpt", (BValue)this.make("LOAD_DISPATCH", "setpoint"));
            this.job.addResult("Bid Energy", (BValue)this.make("BID_ENERGY", "setpoint"));
            this.job.addResult("Bid Load", (BValue)this.make("BID_LOAD", "setpoint"));
            this.job.addResult("Bid Price", (BValue)this.make("BID_PRICE", "price"));
            this.job.addResult("Charge State Delta", (BValue)this.make("CHARGE_STATE", "delta"));
            this.job.addResult("Charge State Multiplier", (BValue)this.make("CHARGE_STATE", "multiplier"));
            this.job.addResult("Charge State Stpt", (BValue)this.make("CHARGE_STATE", "setpoint"));
            this.job.addResult("Load Ctrl Capacity", (BValue)this.make("LOAD_CONTROL", "x-loadControlCapacity"));
            this.job.addResult("Load Ctrl Level Offset", (BValue)this.make("LOAD_CONTROL", "x-loadControlLevelOffset"));
            this.job.addResult("Load Ctrl Pct Offset", (BValue)this.make("LOAD_CONTROL", "x-loadControlPercentOffset"));
            this.job.addResult("Load Ctrl Stpt", (BValue)this.make("LOAD_CONTROL", "x-loadControlSetpoint"));
        }
        this.job.success();
    }

    @Override
    public boolean isUrgent() {
        return true;
    }

    @Override
    protected void execute() {
    }

    private BCadrPointDiscoveryResult make(String name, String type) {
        BCadrPointDiscoveryResult ret = new BCadrPointDiscoveryResult();
        ret.setSignalName(name);
        ret.setSignalType(type);
        if (type.equals("price") || type.equals("priceRelative") || type.equals("priceMultiplier")) {
            ret.setFacets(dollar);
        }
        return ret;
    }

    private BCadrPointDiscoveryResult make(String name, String type, BFacets f) {
        BCadrPointDiscoveryResult ret = this.make(name, type);
        ret.setFacets(f);
        return ret;
    }
}

