/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.BOadrVen2b;
import com.ca.adr.CadrConstants;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.message.CreateReportMessage;
import com.ca.adr.message.EventCreatedMessage;
import com.ca.adr.message.RegisterReportsMessage;
import com.ca.adr.report.BCadrReportRequest;
import com.ca.adr.util.BCadrState;
import com.ca.adr.util.Logging;
import com.ca.adr.util.Message;
import com.ca.adr.util.MessageException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public abstract class OadrMessage
implements CadrConstants,
Logging,
Message {
    protected final BCadrDevice device;
    private String key;

    public OadrMessage(BCadrDevice device) {
        this.device = device;
    }

    public static XElem addSchemaVersion(XElem arg) {
        return arg.addAttr(nsEi, "schemaVersion", "2.0b");
    }

    @Override
    public String getCoalesceKey() {
        if (this.key == null) {
            this.key = this.device.toPathString() + ':' + this.getClass().getName();
        }
        return this.key;
    }

    public BCadrDevice getDevice() {
        return this.device;
    }

    @Override
    public boolean isUrgent() {
        return false;
    }

    public static XElem makeMessage(XElem msg) {
        return OadrMessage.makePayload().addContent((XContent)new XElem(nsOadr2b, "oadrSignedObject").addContent((XContent)msg));
    }

    public static String toDataQuality(BObject source) {
        BStatus status = BStatus.ok;
        if (source instanceof BIStatus) {
            status = ((BIStatus)source).getStatus();
        }
        if (status.isOk()) {
            return "Quality Good - Non Specific";
        }
        if (status.isDisabled()) {
            return "Quality Bad - Out of Service";
        }
        if (status.isFault()) {
            return "Quality Uncertain - Non Specific";
        }
        if (status.isStale()) {
            return "Quality Uncertain - Last Known Value";
        }
        if (status.isNull()) {
            return "Quality Bad - Non Specific";
        }
        if (status.isOverridden()) {
            return "Quality Good - Local Override";
        }
        return "Quality Good - Non Specific";
    }

    @Override
    public void run() {
        try {
            if (!this.canExecute()) {
                return;
            }
            this.execute();
            this.device.pingOk();
        }
        catch (MessageException x) {
            this.device.setState(BCadrState.disconnected);
            this.device.pingFail(x.getMessage());
            this.onMessageFailed();
        }
        catch (Throwable x) {
            this.device.error(this.device.toPathString(), x);
            this.device.setState(BCadrState.disconnected);
            this.device.pingFail(x.toString());
            this.onMessageFailed();
        }
    }

    protected boolean canExecute() {
        return this.device.getState().isConnected();
    }

    protected void cancelReport(XElem oadrCancelReport) {
        String rptReqId = OadrMessage.text(oadrCancelReport, "reportRequestID", false);
        if (rptReqId == null) {
            return;
        }
        String rptToFollow = OadrMessage.text(oadrCancelReport, "reportToFollow", "false");
        BOadrVen2b ven = (BOadrVen2b)this.device;
        BComponent comp = ven.getReports().getRequests();
        SlotCursor c = comp.getProperties();
        while (c.next()) {
            BCadrReportRequest req = (BCadrReportRequest)c.get();
            if (!req.getRequestId().equals(rptReqId)) continue;
            if (rptToFollow.equals("false")) {
                req.cancelNow();
                continue;
            }
            req.cancelAfterNext();
        }
    }

    protected abstract void execute() throws Exception;

    protected static XElem makeEiResponse(String requestId) {
        XElem ret = new XElem(nsEi, "eiResponse");
        ret.addContent((XContent)OadrMessage.x(nsEi, "responseCode", "200"));
        ret.addContent((XContent)OadrMessage.x(nsEi, "responseDescription", "OK"));
        ret.addContent((XContent)OadrMessage.x(nsPyld, "requestID", requestId));
        return ret;
    }

    protected static XElem makeEiResponse(String rid, String code, String desc) {
        XElem ret = new XElem(nsEi, "eiResponse");
        ret.addContent((XContent)OadrMessage.x(nsEi, "responseCode", code));
        ret.addContent((XContent)OadrMessage.x(nsEi, "responseDescription", desc));
        ret.addContent((XContent)OadrMessage.x(nsPyld, "requestID", rid));
        return ret;
    }

    protected static XElem makePayload() {
        XElem ret = new XElem(nsOadr2b, "oadrPayload");
        ret.defineNs(nsOadr2b);
        ret.defineNs(nsEi);
        ret.defineNs(nsEmix);
        ret.defineNs(nsPyld);
        ret.defineNs(nsPower);
        ret.defineNs(nsScale);
        ret.defineNs(nsXcal);
        ret.defineNs(nsStrm);
        return ret;
    }

    protected void onMessageFailed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDistributeEvent(XElem arg) throws Exception {
        String string;
        XElem[] evts;
        String reqId = OadrMessage.text(arg, "requestID", false);
        XElem tmp = arg.elem("eiResponse");
        if (tmp != null) {
            this.validateEiResponse(tmp);
            if (reqId == null) {
                reqId = OadrMessage.text(tmp, "requestID", false);
            }
        }
        ArrayList<BCadrEvent> events = new ArrayList<BCadrEvent>();
        HashSet unfinished = this.device.unfinishedEvents();
        for (XElem xElem : evts = arg.elems("oadrEvent")) {
            XElem evt = OadrMessage.elem(xElem, "eiEvent");
            String str = OadrMessage.text(OadrMessage.elem(evt, "eventDescriptor"), "eventID");
            BCadrEvent bevt = this.device.getEvent(str, true);
            boolean newEvent = bevt.getCreated().isNull();
            bevt.update(evt);
            if (bevt.getResponseRequired()) {
                events.add(bevt);
            }
            if (newEvent) {
                if (this.device.getAlertNewEvents()) {
                    this.device.sendAlert(bevt);
                }
                this.device.fireNewEvent(bevt);
            }
            unfinished.remove(bevt);
        }
        if (!this.device.is2b() && (string = OadrMessage.text(arg, "vtnID", false)) != null && !string.equals(this.device.getVtnId())) {
            this.device.setVtnId(string);
        }
        if (unfinished.size() > 0) {
            for (Object o : unfinished) {
                BCadrEvent bCadrEvent = (BCadrEvent)o;
                bCadrEvent.setEventStatus("cancelled");
            }
        }
        if (events.size() > 0) {
            this.device.enqueue(new EventCreatedMessage(this.device, reqId, events));
        }
        BCadrDevice bCadrDevice = this.device;
        synchronized (bCadrDevice) {
            this.device.scheduleUpdate(System.currentTimeMillis() + 3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOadrResponse(XElem arg) throws Exception {
        XElem[] ary;
        arg = OadrMessage.elem(arg, "oadrSignedObject");
        Object object = ary = arg.elems();
        int n = ((XElem[])object).length;
        block24: for (int i = 0; i < n; ++i) {
            XElem xElem;
            arg = xElem = object[i];
            if (this.trace()) {
                this.trace("%s processing response %s", (Object)this.device.toPathString(), (Object)arg.name());
            }
            switch (arg.name()) {
                case "oadrResponse": 
                case "oadrUpdatedReport": 
                case "oadrRegisteredReport": {
                    this.validateEiResponse(arg.elem("eiResponse"));
                    continue block24;
                }
                case "oadrDistributeEvent": {
                    this.processDistributeEvent(arg);
                    continue block24;
                }
                case "oadrRegisterReport": {
                    this.device.enqueue(new RegisterReportsMessage(this.device, OadrMessage.text(arg, "requestID")));
                    continue block24;
                }
                case "oadrCancelPartyRegistration": {
                    this.device.disconnect();
                    continue block24;
                }
                case "oadrRequestReregistration": {
                    this.device.reconnect();
                    continue block24;
                }
                case "oadrCreateReport": {
                    this.device.enqueue(new CreateReportMessage(this.device, arg));
                    continue block24;
                }
                case "oadrCancelReport": {
                    this.cancelReport(arg);
                    continue block24;
                }
                default: {
                    System.out.println("Unhandled VTN message: " + this.device.toPathString());
                    arg.dump();
                }
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateEiResponse(XElem elem) {
        if (elem == null) {
            return;
        }
        String rc = OadrMessage.text(elem, "responseCode", false);
        if (rc == null) {
            return;
        }
        int i = Integer.parseInt(rc);
        if ((i /= 100) != 2) {
            String desc = OadrMessage.text(elem, "responseDescription", false);
            if (desc == null) {
                desc = "Response Code: " + rc;
            }
            if (i >= 4) {
                throw new MessageException(desc);
            }
            if (this.warn()) {
                this.warn(this.device.toPathString() + " response code " + rc + " (" + desc + ")");
            }
        }
        OadrMessage oadrMessage = this;
        synchronized (oadrMessage) {
            this.notify();
        }
    }

    static XElem elem(XElem parent, String child) {
        return OadrMessage.elem(parent, child, true);
    }

    static XElem elem(XElem parent, String child, boolean checked) {
        if (parent == null && !checked) {
            return null;
        }
        XElem ret = parent.elem(child);
        if (ret == null && checked) {
            throw new MessageException("Missing element: " + child);
        }
        return ret;
    }

    static String text(XElem parent, String child) {
        return OadrMessage.text(parent, child, true);
    }

    static String text(XElem parent, String child, boolean checked) {
        XElem e = OadrMessage.elem(parent, child, checked);
        if (e != null) {
            return e.string();
        }
        return null;
    }

    static String text(XElem parent, String child, String def) {
        String res = OadrMessage.text(parent, child, false);
        if (res != null) {
            return res;
        }
        return def;
    }

    static XElem x(XNs ns, String name) {
        return OadrMessage.x(ns, name, (String)null);
    }

    static XElem x(XNs ns, String name, String text) {
        XElem ret = new XElem(ns, name);
        if (text != null) {
            ret.addText(text);
        }
        return ret;
    }

    static XElem x(XNs ns, String name, XElem child) {
        XElem ret = new XElem(ns, name);
        if (child != null) {
            ret.addContent((XContent)child);
        }
        return ret;
    }

    static XElem opt(XElem parent, XElem child) {
        if (child != null) {
            parent.addContent((XContent)child);
        }
        return parent;
    }
}

