/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.message.OadrMessage;
import java.util.ArrayList;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class EventCreatedMessage
extends OadrMessage {
    private final ArrayList events;
    private final String reqId;

    public EventCreatedMessage(BCadrDevice device, String reqId, ArrayList events) {
        super(device);
        this.reqId = reqId;
        this.events = events;
    }

    @Override
    protected void execute() throws Exception {
        if (this.device.is2b()) {
            XElem elem = EventCreatedMessage.makeCreatedEvent2b(this.device, this.reqId, this.events);
            elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiEvent", elem);
            this.processOadrResponse(elem);
        } else {
            XElem elem = EventCreatedMessage.makeCreatedEvent2a(this.device, this.reqId, this.events);
            elem = this.device.postXml("/OpenADR2/Simple/EiEvent", elem);
            this.validateEiResponse(elem);
        }
    }

    private static XElem makeCreatedEvent2a(BCadrDevice ven, String reqId, ArrayList events) {
        XElem msg = new XElem(nsOadr2a, "oadrCreatedEvent");
        msg.defineNs(nsOadr2a);
        msg.defineNs(nsEi);
        msg.defineNs(nsEmix);
        msg.defineNs(nsPyld);
        XElem ce = new XElem(nsPyld, "eiCreatedEvent");
        ce.addContent((XContent)EventCreatedMessage.makeEiResponse(reqId));
        ce.addContent((XContent)EventCreatedMessage.makeEventResponses(reqId, events));
        ce.addContent((XContent)EventCreatedMessage.x(nsEi, "venID", ven.getVenId()));
        msg.addContent((XContent)ce);
        return msg;
    }

    private static XElem makeCreatedEvent2b(BCadrDevice ven, String reqId, ArrayList events) {
        XElem msg = new XElem(nsOadr2b, "oadrCreatedEvent");
        msg.addAttr(nsEi, "schemaVersion", "2.0b");
        XElem ce = new XElem(nsPyld, "eiCreatedEvent");
        ce.addContent((XContent)EventCreatedMessage.makeEiResponse(reqId));
        ce.addContent((XContent)EventCreatedMessage.makeEventResponses(reqId, events));
        ce.addContent((XContent)EventCreatedMessage.x(nsEi, "venID", ven.getVenId()));
        msg.addContent((XContent)ce);
        return EventCreatedMessage.makeMessage(msg);
    }

    private static XElem makeEventResponses(String reqId, ArrayList events) {
        XElem ret = new XElem(nsEi, "eventResponses");
        for (Object event : events) {
            BCadrEvent evt = (BCadrEvent)event;
            XElem res = new XElem(nsEi, "eventResponse");
            res.addContent((XContent)EventCreatedMessage.x(nsEi, "responseCode", "200"));
            res.addContent((XContent)EventCreatedMessage.x(nsEi, "responseDescription", "OK"));
            res.addContent((XContent)EventCreatedMessage.x(nsPyld, "requestID", reqId));
            XElem qe = new XElem(nsEi, "qualifiedEventID");
            qe.addContent((XContent)EventCreatedMessage.x(nsEi, "eventID", evt.getEventId()));
            qe.addContent((XContent)EventCreatedMessage.x(nsEi, "modificationNumber", evt.getModificationNumber()));
            res.addContent((XContent)EventCreatedMessage.x(nsEi, "optType", evt.getOptIn() ? "optIn" : "optOut"));
            res.addContent((XContent)qe);
            ret.addContent((XContent)res);
        }
        return ret;
    }
}

