/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.message.OadrMessage;
import com.ca.adr.message.RequestEventMessage;
import com.ca.adr.util.BCadrState;
import com.ca.adr.util.Duration;
import javax.baja.sys.BRelTime;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class DeviceConnectMessage
extends OadrMessage {
    public DeviceConnectMessage(BCadrDevice device) {
        super(device);
    }

    @Override
    public boolean isUrgent() {
        return true;
    }

    @Override
    protected boolean canExecute() {
        return this.device.getState().isConnecting();
    }

    @Override
    protected void execute() throws Exception {
        if (this.device.is2b()) {
            String venId = this.device.getVenId();
            if (venId == null || venId.isEmpty()) {
                XElem elem = DeviceConnectMessage.makeCreatePartyRegistration(this.device);
                elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiRegisterParty", elem);
                this.processRegistrationResponse(elem);
            } else {
                XElem elem = DeviceConnectMessage.makeQueryRegistration(this.device);
                elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiRegisterParty", elem);
                try {
                    this.processRegistrationResponse(elem);
                }
                catch (Exception x) {
                    elem = DeviceConnectMessage.makeCreatePartyRegistration(this.device);
                    elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiRegisterParty", elem);
                    this.processRegistrationResponse(elem);
                }
            }
        }
        new RequestEventMessage(this.device).execute();
        this.device.schedulePoll();
        this.device.setState(BCadrState.connected);
    }

    private static XElem makeCreatePartyRegistration(BCadrDevice ven) {
        XElem msg = new XElem(nsOadr2b, "oadrCreatePartyRegistration");
        msg.addAttr(nsEi, "schemaVersion", "2.0b");
        msg.addContent((XContent)DeviceConnectMessage.x(nsPyld, "requestID", ven.getHandle() + ""));
        if (ven.getVenId().trim().length() > 0) {
            msg.addContent((XContent)DeviceConnectMessage.x(nsEi, "venID", ven.getVenId()));
        }
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrProfileName", "2.0b"));
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrTransportName", "simpleHttp"));
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrReportOnly", "false"));
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrXmlSignature", "false"));
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrVenName", ven.getDisplayName(null)));
        msg.addContent((XContent)DeviceConnectMessage.x(nsOadr2b, "oadrHttpPullModel", "true"));
        return DeviceConnectMessage.makeMessage(msg);
    }

    private static XElem makeQueryRegistration(BCadrDevice ven) {
        XElem msg = new XElem(nsOadr2b, "oadrQueryRegistration");
        msg.addAttr(nsEi, "schemaVersion", "2.0b");
        msg.addContent((XContent)DeviceConnectMessage.x(nsPyld, "requestID", ven.getHandle() + ""));
        return DeviceConnectMessage.makeMessage(msg);
    }

    private void processRegistrationResponse(XElem arg) {
        arg = DeviceConnectMessage.elem(DeviceConnectMessage.elem(arg, "oadrSignedObject"), "oadrCreatedPartyRegistration");
        this.validateEiResponse(arg.elem("eiResponse"));
        String str = DeviceConnectMessage.text(arg, "registrationID", false);
        if (str != null && !str.isEmpty() && !str.equals(this.device.getRegistrationId())) {
            this.device.setRegistrationId(str);
        }
        if ((str = DeviceConnectMessage.text(arg, "venID", false)) != null && !str.isEmpty() && !str.equals(this.device.getVenId())) {
            this.device.setVenId(str);
            this.device.cancelReports();
        }
        if ((str = DeviceConnectMessage.text(arg, "vtnID", false)) != null && !str.isEmpty() && !str.equals(this.device.getVtnId())) {
            this.device.setVtnId(str);
        }
        if ((str = DeviceConnectMessage.text(DeviceConnectMessage.elem(arg, "oadrRequestedOadrPollFreq", false), "duration", false)) != null && !str.isEmpty()) {
            BRelTime rt = Duration.make(str).toRelTime();
            this.device.setPollFrequency(rt);
        }
    }
}

