/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.message;

import com.ca.adr.BCadrDevice;
import com.ca.adr.message.OadrMessage;
import com.ca.adr.report.BCadrReportRequest;
import com.ca.adr.report.BTelemetryRequest;
import com.ca.adr.report.BTelemetryStatusRequest;
import com.ca.adr.report.BTelemetryUsageRequest;
import com.ca.adr.util.Csv;
import com.ca.adr.util.Duration;
import java.util.ArrayList;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class CreateReportMessage
extends OadrMessage {
    private final XElem oadrCreateReport;

    public CreateReportMessage(BCadrDevice device, XElem oadrCreateReport) {
        super(device);
        this.oadrCreateReport = oadrCreateReport;
    }

    @Override
    protected void execute() throws Exception {
        BCadrReportRequest req;
        String reqId = CreateReportMessage.text(this.oadrCreateReport, "requestID");
        XElem[] elems = this.oadrCreateReport.elems("oadrReportRequest");
        ArrayList<BCadrReportRequest> requests = new ArrayList<BCadrReportRequest>();
        XElem pending = CreateReportMessage.x(nsOadr2b, "oadrPendingReports");
        for (XElem xElem : elems) {
            try {
                req = this.process(xElem);
                requests.add(req);
                pending.addContent((XContent)CreateReportMessage.x(nsEi, "reportRequestID", req.getRequestId()));
            }
            catch (Exception exception) {
                this.error(this.device.toPathString(), exception);
            }
        }
        XElem eiRes = requests.size() > 0 ? CreateReportMessage.makeEiResponse(reqId) : CreateReportMessage.makeEiResponse(reqId, "469", "No reports created");
        XElem elem = CreateReportMessage.makeCreatedReport(this.device, eiRes, pending);
        elem = this.device.postXml("/OpenADR2/Simple/2.0b/EiReport", elem);
        this.processOadrResponse(elem);
        BComponent folder = this.device.getReports().getRequests();
        for (Object e : requests) {
            req = (BCadrReportRequest)e;
            folder.add(SlotPath.escape((String)req.getRequestId()), (BValue)req);
        }
        Sys.getStation().save();
    }

    private static XElem makeCreatedReport(BCadrDevice ven, XElem eiResponse, XElem pendingReports) {
        XElem cr = new XElem(nsOadr2b, "oadrCreatedReport");
        cr.addAttr(nsEi, "schemaVersion", "2.0b");
        cr.addContent((XContent)eiResponse);
        if (pendingReports != null) {
            cr.addContent((XContent)pendingReports);
        }
        cr.addContent((XContent)CreateReportMessage.x(nsEi, "venID", ven.getVenId()));
        return CreateReportMessage.makeMessage(cr);
    }

    private BCadrReportRequest process(XElem rptReq) throws Exception {
        BTelemetryRequest req;
        XElem rptSpf = CreateReportMessage.elem(rptReq, "reportSpecifier");
        String rptSpfId = CreateReportMessage.text(rptSpf, "reportSpecifierID");
        if (rptSpfId.equals("TELEMETRY_USAGE")) {
            req = new BTelemetryUsageRequest();
        } else if (rptSpfId.equals("TELEMETRY_STATUS")) {
            req = new BTelemetryStatusRequest();
        } else {
            throw new IllegalStateException("Invalid reportSpecifierID: " + rptSpfId);
        }
        req.setSpecifierId(rptSpfId);
        req.setRequestId(CreateReportMessage.text(rptReq, "reportRequestID"));
        String dur = CreateReportMessage.text(CreateReportMessage.elem(rptSpf, "granularity", true), "duration", "PT0M");
        req.setUpdateBufferRate(Duration.make(dur).toRelTime());
        dur = CreateReportMessage.text(CreateReportMessage.elem(rptSpf, "reportBackDuration", true), "duration", "PT0M");
        BRelTime relTime = Duration.make(dur).toRelTime();
        req.setReportBackRate(relTime);
        if (relTime.getMillis() > 0L) {
            XElem prop = CreateReportMessage.elem(CreateReportMessage.elem(rptSpf, "reportInterval"), "properties");
            String time = CreateReportMessage.text(CreateReportMessage.elem(prop, "dtstart"), "date-time");
            BAbsTime start = BAbsTime.make((String)time);
            dur = CreateReportMessage.text(CreateReportMessage.elem(prop, "duration", false), "duration", "PT0M");
            relTime = Duration.make(dur).toRelTime();
            BAbsTime end = BAbsTime.NULL;
            if (relTime.getMillis() > 0L) {
                end = start.add(relTime);
            }
            req.setStartTime(start);
            req.setEndTime(end);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (XElem sp : rptSpf.elems("specifierPayload")) {
            XElem rid = sp.elem("rID");
            if (rid == null) continue;
            ids.add(rid.string());
        }
        req.setDataPoints(Csv.makeRow(ids, ',', null).toString());
        return req;
    }
}

