/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.event;

import com.ca.adr.BCadrObject;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.event.BCadrInterval;
import com.ca.adr.util.BCadrSignalTargets;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;

public class BCadrSignal
extends BCadrObject {
    public static final Property signalId = BCadrSignal.newProperty((int)1, (String)"", null);
    public static final Property signalName = BCadrSignal.newProperty((int)1, (String)"", null);
    public static final Property signalType = BCadrSignal.newProperty((int)1, (String)"", null);
    public static final Property targets = BCadrSignal.newProperty((int)1, (BValue)BCadrSignalTargets.NULL, null);
    public static final Property unit = BCadrSignal.newProperty((int)1, (BValue)BUnit.NULL, null);
    public static final Type TYPE = Sys.loadType(BCadrSignal.class);

    public String getSignalId() {
        return this.getString(signalId);
    }

    public void setSignalId(String v) {
        this.setString(signalId, v, null);
    }

    public String getSignalName() {
        return this.getString(signalName);
    }

    public void setSignalName(String v) {
        this.setString(signalName, v, null);
    }

    public String getSignalType() {
        return this.getString(signalType);
    }

    public void setSignalType(String v) {
        this.setString(signalType, v, null);
    }

    public BCadrSignalTargets getTargets() {
        return (BCadrSignalTargets)this.get(targets);
    }

    public void setTargets(BCadrSignalTargets v) {
        this.set(targets, (BValue)v, null);
    }

    public BUnit getUnit() {
        return (BUnit)this.get(unit);
    }

    public void setUnit(BUnit v) {
        this.set(unit, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCadrInterval activeInterval(long actualStart, long time) {
        BCadrInterval[] ivls;
        if (actualStart > time) {
            return null;
        }
        long cur = actualStart;
        for (BCadrInterval bCadrInterval : ivls = (BCadrInterval[])this.getChildren(BCadrInterval.class)) {
            BCadrInterval ivl = bCadrInterval;
            long millis = ivl.getDuration().getMillis();
            if (millis == 0L) {
                return ivl;
            }
            if ((cur += ivl.getDuration().getMillis()) <= time) continue;
            return ivl;
        }
        return null;
    }

    public BCadrInterval firstInterval() {
        BCadrInterval[] ivls = (BCadrInterval[])this.getChildren(BCadrInterval.class);
        if (ivls.length > 0) {
            return ivls[0];
        }
        return null;
    }

    public BCadrEvent getEvent() {
        return (BCadrEvent)this.getParent();
    }

    public BIcon getIcon() {
        return icnSgl;
    }

    public List getIntervals(List bucket) {
        if (bucket == null) {
            bucket = new ArrayList<BCadrInterval>();
        }
        BCadrInterval[] ivls = (BCadrInterval[])this.getChildren(BCadrInterval.class);
        bucket.addAll(Arrays.asList(ivls));
        return bucket;
    }

    public long nextIntervalStart(long actualStart, long time) {
        BCadrInterval[] ivls;
        if (actualStart > time) {
            return actualStart;
        }
        long cur = actualStart;
        for (BCadrInterval bCadrInterval : ivls = (BCadrInterval[])this.getChildren(BCadrInterval.class)) {
            BCadrInterval ivl = bCadrInterval;
            long millis = ivl.getDuration().getMillis();
            if (millis == 0L) {
                return -1L;
            }
            if ((cur += millis) <= time) continue;
            return cur;
        }
        return -1L;
    }

    protected void prettyPrint(PrintWriter out) {
        String indent = "  ";
        out.println("Signal ID: " + this.getSignalId());
        out.print(indent);
        out.println("Name: " + this.getSignalName());
        out.print(indent);
        out.println("Type: " + this.getSignalType());
        out.print(indent);
        out.println("Targets: " + this.getTargets());
        List list = this.getIntervals(null);
        for (Object o : list) {
            ((BCadrInterval)o).prettyPrint(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(XElem signal) throws Exception {
        String sn = BCadrSignal.text(signal, "signalName");
        this.setSignalName(sn);
        String st = BCadrSignal.text(signal, "signalType");
        this.setSignalType(st);
        BCadrSignalTargets tgts = (BCadrSignalTargets)BCadrSignalTargets.NULL.decodeXml(BCadrSignal.elems(BCadrSignal.elem(signal, "eiTarget", false), null));
        if (!this.getTargets().equals(tgts)) {
            this.setTargets(tgts);
        }
        if (sn.equals("LOAD_DISPATCH") || sn.equals("BID_LOAD")) {
            this.getPowerUnits(signal);
        } else if (sn.equals("BID_ENERGY") || sn.equals("CHARGE_STATE")) {
            this.getEnergyUnits(signal);
        }
        this.updateIntervals(BCadrSignal.elems(BCadrSignal.elem(signal, "intervals"), "interval"));
        Class<BCadrSignal> clazz = BCadrSignal.class;
        synchronized (BCadrSignal.class) {
            BCadrSignal.class.notify();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    void updateIntervals(XElem[] ivls) throws Exception {
        BCadrInterval ivl;
        Map map = this.getIntervals();
        int len = ivls.length;
        for (int i = 0; i < len; ++i) {
            String name = "interval" + i;
            ivl = (BCadrInterval)map.remove(name);
            if (ivl == null) {
                ivl = new BCadrInterval();
                this.add(name, (BValue)ivl);
            }
            ivl.update(ivls[i]);
        }
        for (Object o : map.values()) {
            ivl = (BCadrInterval)o;
            Property p = ivl.getPropertyInParent();
            this.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEnergyUnits(XElem signal) {
        XElem e = BCadrSignal.opt(signal, "energyReal");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"watt hour"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilowatt hour"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megawatt hour"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"watt hour"));
            }
            return;
        }
        e = BCadrSignal.opt(signal, "energyApparent");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"volt ampere hour"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilovolt ampere hour"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megavolt ampere hour"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"volt ampere hour"));
            }
            return;
        }
        e = BCadrSignal.opt(signal, "energyReactive");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"volt ampere hour reactive"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilovolt ampere hour reactive"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megavolt ampere hour reactive"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"volt ampere hour reactive"));
            }
            return;
        }
        Class<BCadrSignal> clazz = BCadrSignal.class;
        synchronized (BCadrSignal.class) {
            BCadrSignal.class.notify();
            // ** MonitorExit[var3_6] (shouldn't be in output)
            return;
        }
    }

    private Map getIntervals() {
        BCadrInterval[] ivls;
        TreeMap<String, BCadrInterval> ret = new TreeMap<String, BCadrInterval>();
        for (BCadrInterval ivl : ivls = (BCadrInterval[])this.getChildren(BCadrInterval.class)) {
            ret.put(ivl.getName(), ivl);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPowerUnits(XElem signal) {
        XElem e = BCadrSignal.opt(signal, "powerReal");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"watt"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilowatt"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megawatt"));
            } else if ("G".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"gigawatt"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"watt"));
            }
            return;
        }
        e = BCadrSignal.opt(signal, "powerApparent");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"volt ampere"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilovolt ampere"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megavolt ampere"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"volt ampere"));
            }
            return;
        }
        e = BCadrSignal.opt(signal, "powerReactive");
        if (e != null) {
            String scale = BCadrSignal.text(e, "siScaleCode", false);
            if (scale == null) {
                this.setUnit(BUnit.getUnit((String)"volt ampere reactive"));
            } else if ("k".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"kilovolt ampere reactive"));
            } else if ("M".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"megavolt ampere reactive"));
            } else if ("none".equals(scale)) {
                this.setUnit(BUnit.getUnit((String)"volt ampere reactive"));
            }
            return;
        }
        Class<BCadrSignal> clazz = BCadrSignal.class;
        synchronized (BCadrSignal.class) {
            BCadrSignal.class.notify();
            // ** MonitorExit[var3_6] (shouldn't be in output)
            return;
        }
    }
}

