/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.event;

import com.ca.adr.BCadrObject;
import com.ca.adr.event.BCadrSignal;
import com.ca.adr.util.BCadrEventState;
import com.ca.adr.util.BCadrEventTargets;
import com.ca.adr.util.Duration;
import com.ca.adr.util.Logging;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BCadrEvent
extends BCadrObject
implements BIAlarmSource,
Logging {
    public static final Property eventId = BCadrEvent.newProperty((int)1, (String)"", null);
    public static final Property eventState = BCadrEvent.newProperty((int)1, (BValue)BCadrEventState.far, null);
    public static final Property eventStatus = BCadrEvent.newProperty((int)5, (String)"", null);
    public static final Property optIn = BCadrEvent.newProperty((int)0, (boolean)true, null);
    public static final Property responseRequired = BCadrEvent.newProperty((int)5, (boolean)true, (BFacets)BFacets.makeBoolean((String)"always", (String)"never"));
    public static final Property start = BCadrEvent.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property duration = BCadrEvent.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property ramp = BCadrEvent.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property recovery = BCadrEvent.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property tolerance = BCadrEvent.newProperty((int)1, (BValue)BRelTime.DEFAULT, null);
    public static final Property program = BCadrEvent.newProperty((int)1, (String)"", null);
    public static final Property priority = BCadrEvent.newProperty((int)1, (int)0, null);
    public static final Property testEvent = BCadrEvent.newProperty((int)1, (boolean)false, null);
    public static final Property created = BCadrEvent.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property modificationNumber = BCadrEvent.newProperty((int)1, (String)"", null);
    public static final Property modificationDateTime = BCadrEvent.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property modificationReason = BCadrEvent.newProperty((int)1, (String)"", null);
    public static final Property vtnComment = BCadrEvent.newProperty((int)1, (String)"", null);
    public static final Property targets = BCadrEvent.newProperty((int)1, (BValue)BCadrEventTargets.NULL, null);
    public static final Type TYPE = Sys.loadType(BCadrEvent.class);
    private List signals;

    public String getEventId() {
        return this.getString(eventId);
    }

    public void setEventId(String v) {
        this.setString(eventId, v, null);
    }

    public BCadrEventState getEventState() {
        return (BCadrEventState)this.get(eventState);
    }

    public void setEventState(BCadrEventState v) {
        this.set(eventState, (BValue)v, null);
    }

    public String getEventStatus() {
        return this.getString(eventStatus);
    }

    public void setEventStatus(String v) {
        this.setString(eventStatus, v, null);
    }

    public boolean getOptIn() {
        return this.getBoolean(optIn);
    }

    public void setOptIn(boolean v) {
        this.setBoolean(optIn, v, null);
    }

    public boolean getResponseRequired() {
        return this.getBoolean(responseRequired);
    }

    public void setResponseRequired(boolean v) {
        this.setBoolean(responseRequired, v, null);
    }

    public BAbsTime getStart() {
        return (BAbsTime)this.get(start);
    }

    public void setStart(BAbsTime v) {
        this.set(start, (BValue)v, null);
    }

    public BRelTime getDuration() {
        return (BRelTime)this.get(duration);
    }

    public void setDuration(BRelTime v) {
        this.set(duration, (BValue)v, null);
    }

    public BRelTime getRamp() {
        return (BRelTime)this.get(ramp);
    }

    public void setRamp(BRelTime v) {
        this.set(ramp, (BValue)v, null);
    }

    public BRelTime getRecovery() {
        return (BRelTime)this.get(recovery);
    }

    public void setRecovery(BRelTime v) {
        this.set(recovery, (BValue)v, null);
    }

    public BRelTime getTolerance() {
        return (BRelTime)this.get(tolerance);
    }

    public void setTolerance(BRelTime v) {
        this.set(tolerance, (BValue)v, null);
    }

    public String getProgram() {
        return this.getString(program);
    }

    public void setProgram(String v) {
        this.setString(program, v, null);
    }

    public int getPriority() {
        return this.getInt(priority);
    }

    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    public boolean getTestEvent() {
        return this.getBoolean(testEvent);
    }

    public void setTestEvent(boolean v) {
        this.setBoolean(testEvent, v, null);
    }

    public BAbsTime getCreated() {
        return (BAbsTime)this.get(created);
    }

    public void setCreated(BAbsTime v) {
        this.set(created, (BValue)v, null);
    }

    public String getModificationNumber() {
        return this.getString(modificationNumber);
    }

    public void setModificationNumber(String v) {
        this.setString(modificationNumber, v, null);
    }

    public BAbsTime getModificationDateTime() {
        return (BAbsTime)this.get(modificationDateTime);
    }

    public void setModificationDateTime(BAbsTime v) {
        this.set(modificationDateTime, (BValue)v, null);
    }

    public String getModificationReason() {
        return this.getString(modificationReason);
    }

    public void setModificationReason(String v) {
        this.setString(modificationReason, v, null);
    }

    public String getVtnComment() {
        return this.getString(vtnComment);
    }

    public void setVtnComment(String v) {
        this.setString(vtnComment, v, null);
    }

    public BCadrEventTargets getTargets() {
        return (BCadrEventTargets)this.get(targets);
    }

    public void setTargets(BCadrEventTargets v) {
        this.set(targets, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BBoolean ackAlarm(BAlarmRecord rec) {
        try {
            BAlarmService svc;
            if (rec.getAckState() != BAckState.acked && rec.getAckState() != BAckState.ackPending) {
                rec.setAckTime(Clock.time());
                rec.setAckState(BAckState.acked);
            }
            if ((svc = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).isRunning()) {
                svc.routeAlarm(rec);
            }
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
        return BBoolean.TRUE;
    }

    public void added(Property p, Context cx) {
        this.signals = null;
        super.added(p, cx);
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && p.equals(optIn)) {
            this.getDevice().refreshEvents();
        }
        super.changed(p, cx);
    }

    public BIcon getIcon() {
        return icnEvt;
    }

    public long actualRampStart() {
        long millis = this.getRamp().getMillis();
        if (millis == 0L) {
            return -1L;
        }
        return this.actualEventStart() - millis;
    }

    public long actualEventStart() {
        long ret = this.getStart().getMillis();
        long tol = this.getTolerance().getMillis();
        if (tol == 0L) {
            return ret;
        }
        tol = (long)((double)tol * this.getDevice().getToleranceRandom());
        return ret + tol;
    }

    public long actualEventEnd() {
        long time = this.actualEventStart();
        return time + this.getDuration().getMillis();
    }

    public long actualRecoveryEnd() {
        return this.actualEventEnd() + this.getRecovery().getMillis();
    }

    public boolean isCancelled() {
        return this.getEventStatus().equalsIgnoreCase("cancelled");
    }

    public boolean isNear() {
        return this.getEventStatus().equalsIgnoreCase("near");
    }

    public Map getSignalMap() {
        BCadrSignal[] sig;
        TreeMap<String, BCadrSignal> ret = new TreeMap<String, BCadrSignal>();
        for (BCadrSignal bCadrSignal : sig = (BCadrSignal[])this.getChildren(BCadrSignal.class)) {
            ret.put(bCadrSignal.getSignalId(), bCadrSignal);
        }
        return ret;
    }

    public List getSignals() {
        if (this.signals == null) {
            this.signals = Arrays.asList(this.getChildren(BCadrSignal.class));
        }
        return this.signals;
    }

    public long nextUpdate(long time) {
        BCadrSignal[] sig;
        if (this.getEventState().isFinished()) {
            return -1L;
        }
        long end = this.actualRecoveryEnd();
        if (time > end) {
            return -1L;
        }
        long ret = this.actualRampStart();
        if (ret > time) {
            return ret;
        }
        long actualEventStart = this.actualEventStart();
        if (actualEventStart > time) {
            return actualEventStart;
        }
        ret = -1L;
        for (BCadrSignal bCadrSignal : sig = (BCadrSignal[])this.getChildren(BCadrSignal.class)) {
            long tmp = bCadrSignal.nextIntervalStart(actualEventStart, time);
            if (tmp <= time) continue;
            if (ret < 0L) {
                ret = tmp;
                continue;
            }
            if (ret <= tmp) continue;
            ret = tmp;
        }
        if (ret > time) {
            return ret;
        }
        ret = this.actualEventEnd();
        if (ret > time) {
            return ret;
        }
        return end;
    }

    public void prettyPrint(PrintWriter out) {
        out.println("Event ID: " + this.getEventId());
        out.println("State: " + (Object)((Object)this.getEventState()));
        out.println("Start: " + this.getStart());
        out.println("Duration: " + this.getDuration());
        out.println("Targets: " + this.getTargets());
        List sigs = this.getSignals();
        for (Object sig : sigs) {
            ((BCadrSignal)sig).prettyPrint(out);
        }
        if (this.getVtnComment().length() > 0) {
            out.println("VTN Comment: " + this.getVtnComment());
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        this.signals = null;
        super.removed(p, v, cx);
    }

    @Override
    public void started() throws Exception {
        Property p = this.getProperty("marketContext");
        if (p != null) {
            this.set("program", this.get(p));
            this.remove(p);
        }
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XElem evt) throws Exception {
        XElem tmp = BCadrEvent.elem(evt, "eventDescriptor");
        String str = BCadrEvent.text(tmp, "modificationDateTime", null);
        if (str != null) {
            this.setModificationDateTime(BAbsTime.make((String)str));
        }
        if ((str = BCadrEvent.text(tmp, "createdDateTime", null)) != null) {
            this.setCreated(BAbsTime.make((String)str));
        } else {
            this.setCreated(Clock.time());
        }
        this.setResponseRequired(!BCadrEvent.text(evt, "cadrResponseRequired", "always").equals("never"));
        this.setModificationNumber(BCadrEvent.text(tmp, "modificationNumber", ""));
        this.setModificationReason(BCadrEvent.text(tmp, "modificationReason", ""));
        this.setVtnComment(BCadrEvent.text(tmp, "vtnComment", ""));
        this.setPriority(Integer.parseInt(BCadrEvent.text(tmp, "priority", "0")));
        this.setProgram(BCadrEvent.text(BCadrEvent.elem(tmp, "eiMarketContext"), "marketContext"));
        this.setTestEvent("true".equalsIgnoreCase(BCadrEvent.text(tmp, "testEvent", "false")));
        this.setEventStatus(BCadrEvent.text(tmp, "eventStatus", "???"));
        tmp = BCadrEvent.elem(BCadrEvent.elem(evt, "eiActivePeriod"), "properties");
        this.setStart(BAbsTime.make((String)BCadrEvent.text(BCadrEvent.elem(tmp, "dtstart"), "date-time")));
        this.setDuration(Duration.make(BCadrEvent.text(BCadrEvent.elem(tmp, "duration"), "duration")).toRelTime());
        str = BCadrEvent.text(BCadrEvent.opt(BCadrEvent.opt(tmp, "tolerance"), "tolerate"), "startafter", false);
        if (str != null) {
            this.setTolerance(Duration.make(str).toRelTime());
        }
        if ((str = BCadrEvent.text(BCadrEvent.opt(tmp, "x-eiRampUp"), "duration", false)) != null) {
            this.setRamp(Duration.make(str).toRelTime());
        }
        if ((str = BCadrEvent.text(BCadrEvent.opt(tmp, "x-eiRecovery"), "duration", false)) != null) {
            this.setRecovery(Duration.make(str).toRelTime());
        }
        BCadrEventTargets tgts = (BCadrEventTargets)BCadrEventTargets.NULL.decodeXml(BCadrEvent.elems(BCadrEvent.elem(evt, "eiTarget", false), null));
        if (!this.getTargets().equals(tgts)) {
            this.setTargets(tgts);
        }
        this.updateSignals(BCadrEvent.elems(BCadrEvent.elem(evt, "eiEventSignals"), "eiEventSignal"));
        this.updateState(System.currentTimeMillis());
        Class<BCadrEvent> clazz = BCadrEvent.class;
        synchronized (BCadrEvent.class) {
            BCadrEvent.class.notify();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public BCadrEventState updateState(long now) {
        if (this.isCancelled()) {
            return this.setState(BCadrEventState.cancelled);
        }
        if (!this.getOptIn()) {
            return this.setState(BCadrEventState.optOut);
        }
        long end = this.actualRecoveryEnd();
        if (now > end) {
            return this.setState(BCadrEventState.completed);
        }
        long ret = this.actualRampStart();
        if (ret > now) {
            if (this.isNear()) {
                return this.setState(BCadrEventState.near);
            }
            return this.setState(BCadrEventState.far);
        }
        long actualEventStart = this.actualEventStart();
        if (actualEventStart > now) {
            if (ret > 0L) {
                return this.setState(BCadrEventState.ramp);
            }
            if (this.isNear()) {
                return this.setState(BCadrEventState.near);
            }
            return this.setState(BCadrEventState.far);
        }
        ret = this.actualEventEnd();
        if (ret > now) {
            return this.setState(BCadrEventState.active);
        }
        return this.setState(BCadrEventState.recovery);
    }

    private BCadrEventState setState(BCadrEventState state) {
        if (this.getEventState() != state) {
            this.setEventState(state);
        }
        return state;
    }

    private void updateSignals(XElem[] signals) throws Exception {
        BCadrSignal sig;
        Map cur = this.getSignalMap();
        for (XElem signal : signals) {
            String str = BCadrEvent.text(signal, "signalID");
            sig = (BCadrSignal)cur.remove(str);
            if (sig == null) {
                sig = new BCadrSignal();
                sig.setSignalId(str);
                this.add(SlotPath.escape((String)str), (BValue)sig);
            }
            sig.update(signal);
        }
        for (Object o : cur.values()) {
            sig = (BCadrSignal)o;
            Property p = sig.getPropertyInParent();
            this.remove(p);
        }
    }
}

