/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr;

import com.ca.adr.BCadrDevice;
import com.ca.adr.BCadrNetwork;
import com.ca.adr.CadrConstants;
import com.ca.adr.util.Csv;
import com.ca.adr.util.MessageException;
import java.util.ArrayList;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;

public class BCadrObject
extends BComponent
implements CadrConstants {
    public static final Type TYPE = Sys.loadType(BCadrObject.class);
    private BCadrDevice device;

    public Type getType() {
        return TYPE;
    }

    public void enqueue(Runnable r) {
        this.getDevice().enqueue(r);
    }

    public BCadrDevice getDevice() {
        if (this.device == null) {
            BComplex c = this.getParent();
            while (c != null) {
                if (c instanceof BCadrDevice) {
                    this.device = (BCadrDevice)c;
                    c = null;
                    continue;
                }
                c = c.getParent();
            }
        }
        return this.device;
    }

    public BCadrNetwork getNetwork() {
        return BCadrNetwork.getInstance();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public void started() throws Exception {
        this.device = null;
        super.started();
    }

    protected static XElem elem(XElem parent, String child) {
        return BCadrObject.elem(parent, child, true);
    }

    protected static XElem elem(XElem parent, String child, boolean checked) {
        if (parent == null && !checked) {
            return null;
        }
        XElem ret = parent.elem(child);
        if (ret == null && checked) {
            throw new MessageException("Missing element: " + child);
        }
        return ret;
    }

    protected static XElem[] elems(XElem parent, String name) {
        XElem[] ret = null;
        if (parent != null) {
            ret = name == null ? parent.elems() : parent.elems(name);
        }
        if (ret == null) {
            return new XElem[0];
        }
        return ret;
    }

    protected static XElem opt(XElem parent, String child) {
        return BCadrObject.elem(parent, child, false);
    }

    protected static String text(XElem parent, String child) {
        return BCadrObject.text(parent, child, true);
    }

    protected static String text(XElem parent, String child, boolean checked) {
        XElem e = BCadrObject.elem(parent, child, checked);
        if (e != null) {
            return e.string();
        }
        return null;
    }

    protected static String text(XElem parent, String child, String def) {
        XElem e = BCadrObject.elem(parent, child, false);
        if (e != null) {
            String ret = e.string();
            if (ret == null) {
                return def;
            }
            return ret;
        }
        return def;
    }

    protected static String toCsv(ArrayList list) {
        if (list == null) {
            return "";
        }
        return Csv.makeRow(list, ',', null).toString();
    }

    protected static XElem x(XNs ns, String name) {
        return BCadrObject.x(ns, name, (String)null);
    }

    protected static XElem x(XNs ns, String name, String text) {
        XElem ret = new XElem(ns, name);
        if (text != null) {
            ret.addText(text);
        }
        return ret;
    }

    protected static XElem x(XNs ns, String name, XElem child) {
        XElem ret = new XElem(ns, name);
        if (child != null) {
            ret.addContent((XContent)child);
        }
        return ret;
    }
}

