/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr;

import com.ca.adr.BCadrDevice;
import com.ca.adr.BCadrDeviceFolder;
import com.ca.adr.CadrConstants;
import com.ca.adr.NiagaraBridge;
import com.ca.adr.util.BCadrState;
import com.ca.adr.util.Logging;
import com.ca.adr.util.ThreadPool;
import com.tridium.util.ComponentTreeCursor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BCadrNetwork
extends BDeviceNetwork
implements CadrConstants,
Logging {
    public static final Property version = BCadrNetwork.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property state = BCadrNetwork.newProperty((int)71, (BValue)BCadrState.disconnected, null);
    public static final Property actualConnections = BCadrNetwork.newProperty((int)3, (int)0, null);
    public static final Property maxConnections = BCadrNetwork.newProperty((int)0, (int)1, null);
    public static final Property productCode = BCadrNetwork.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property licenseKey = BCadrNetwork.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property licenseStatus = BCadrNetwork.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property expiration = BCadrNetwork.newProperty((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action testConnection = BCadrNetwork.newAction((int)0, (BValue)BString.make((String)"http://checkip.amazonaws.com/"), null);
    public static final Action ping = BCadrNetwork.newAction((int)2052, null);
    public static final Action connect = BCadrNetwork.newAction((int)2052, null);
    public static final Action disconnect = BCadrNetwork.newAction((int)2052, null);
    public static final Action enable = BCadrNetwork.newAction((int)16, null);
    public static final Action disable = BCadrNetwork.newAction((int)16, null);
    public static final Action pingNetwork = BCadrNetwork.newAction((int)2068, null);
    public static final Action addExpiration = BCadrNetwork.newAction((int)4, null);
    public static final Action clearExpiration = BCadrNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCadrNetwork.class);
    private static BCadrNetwork instance;
    private boolean steady = false;
    private static ThreadPool threads;

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    public BCadrState getState() {
        return (BCadrState)this.get(state);
    }

    public void setState(BCadrState v) {
        this.set(state, (BValue)v, null);
    }

    public int getActualConnections() {
        return this.getInt(actualConnections);
    }

    public void setActualConnections(int v) {
        this.setInt(actualConnections, v, null);
    }

    public int getMaxConnections() {
        return this.getInt(maxConnections);
    }

    public void setMaxConnections(int v) {
        this.setInt(maxConnections, v, null);
    }

    public String getProductCode() {
        return this.getString(productCode);
    }

    public void setProductCode(String v) {
        this.setString(productCode, v, null);
    }

    public String getLicenseKey() {
        return this.getString(licenseKey);
    }

    public void setLicenseKey(String v) {
        this.setString(licenseKey, v, null);
    }

    public String getLicenseStatus() {
        return this.getString(licenseStatus);
    }

    public void setLicenseStatus(String v) {
        this.setString(licenseStatus, v, null);
    }

    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    public void setExpiration(BAbsTime v) {
        this.set(expiration, (BValue)v, null);
    }

    public void testConnection(BString arg) {
        this.invoke(testConnection, (BValue)arg, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public void pingNetwork() {
        this.invoke(pingNetwork, null, null);
    }

    public void addExpiration() {
        this.invoke(addExpiration, null, null);
    }

    public void clearExpiration() {
        this.invoke(clearExpiration, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public synchronized void addConnection() {
        this.setActualConnections(this.getActualConnections() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atSteadyState() {
        try {
            super.atSteadyState();
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
        Class<BCadrNetwork> clazz = BCadrNetwork.class;
        synchronized (BCadrNetwork.class) {
            boolean bl = this.steady = this.isRunning() && !this.getStatus().isFault();
            if (threads.init(this)) {
                this.ping();
            }
            BCadrNetwork.class.notify();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (c != Context.decoding && this.isRunning() && p.equals(status)) {
            if (this.isDown() || this.isDisabled() || this.isFault() || this.isFatalFault()) {
                if (this.getState().isEngaged()) {
                    this.disconnect();
                }
            } else if (this.getState().isDisengaged()) {
                this.ping();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configFailure(String message) {
        this.doDisconnect();
        this.steady = false;
        this.configFail(message);
        Class<BCadrNetwork> clazz = BCadrNetwork.class;
        synchronized (BCadrNetwork.class) {
            BCadrNetwork.class.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configSuccess() {
        boolean bl = this.steady = this.isRunning() && Sys.atSteadyState() && instance == this;
        if (this.steady) {
            this.configOk();
        }
        Class<BCadrNetwork> clazz = BCadrNetwork.class;
        synchronized (BCadrNetwork.class) {
            BCadrNetwork.class.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void doAddExpiration() {
        BAbsTime b = Clock.time();
        b = b.nextMonth();
        b = BAbsTime.make((int)b.getYear(), (BMonth)b.getMonth(), (int)b.getDay());
        this.setExpiration(b);
    }

    public void doClearExpiration() {
        this.setExpiration(BAbsTime.NULL);
    }

    public synchronized void doConnect() {
        if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault() || !this.steady) {
            return;
        }
        this.setState(BCadrState.connected);
        this.pingOk();
    }

    public synchronized void doDisconnect() {
        if (this.getState().isDisengaged()) {
            return;
        }
        this.setState(BCadrState.disconnected);
        this.getHealth().setDown(true);
    }

    public void doDisable() {
        this.setEnabled(false);
    }

    public void doEnable() {
        this.setEnabled(true);
    }

    public void doPing() {
        if (!this.steady) {
            return;
        }
        if (this.getState().isDisconnected()) {
            this.connect();
        }
    }

    public void doPingNetwork() {
        ArrayList list = this.getAllDevices();
        threads.init(this);
        int i = 0;
        while (--i >= 0) {
            BCadrDevice dev = (BCadrDevice)list.get(i);
            dev.ping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestConnection(BString url) throws Exception {
        BufferedReader in = null;
        try {
            System.out.println("\n***** Test Connection: " + this.toPathString());
            HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
            System.out.println("HTTP Response: " + conn.getResponseMessage());
            int rc = conn.getResponseCode();
            in = rc < 200 || rc >= 400 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = in.readLine();
            while (line != null) {
                System.out.println(line);
                line = in.readLine();
            }
            System.out.println("***** Test Connection Finished");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {
                    this.debug(this.toPathString(), x);
                }
            }
        }
    }

    public void enqueue(Runnable r) {
        threads.enqueue(r);
    }

    public ArrayList getAllDevices() {
        ArrayList<BValue> list = new ArrayList<BValue>();
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, BCadrDevice.TYPE, null);
        while (cur.next(BCadrDevice.class)) {
            list.add(cur.get());
        }
        return list;
    }

    public Type getDeviceFolderType() {
        return BCadrDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BCadrDevice.TYPE;
    }

    public BIcon getIcon() {
        return icnCa;
    }

    public static BCadrNetwork getInstance() {
        return instance;
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public synchronized void removeConnection() {
        this.setActualConnections(this.getActualConnections() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        try {
            this.setVersion(NiagaraBridge.getVersion(TYPE.getModule()));
            this.setProductCode(this.prodCode());
            this.setState(BCadrState.disconnected);
            this.getHealth().setDown(true);
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
        Class<BCadrNetwork> clazz = BCadrNetwork.class;
        synchronized (BCadrNetwork.class) {
            if (threads == null) {
                threads = new ThreadPool();
            }
            if (instance != null) {
                if (instance != this) {
                    this.configFailure(instance.toPathString());
                    this.error("Duplicate CadrNetwork " + this.toPathString());
                }
            } else {
                instance = this;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            if (Sys.atSteadyState()) {
                this.atSteadyState();
            }
            super.started();
            return;
        }
    }

    public void stopped() throws Exception {
        this.setState(BCadrState.disconnected);
        this.getHealth().setDown(true);
        if (instance == this) {
            instance = null;
        }
        super.stopped();
    }

    public String toString(Context cx) {
        return this.getDisplayName(cx);
    }

    private String prodCode() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getType().getModule().getModuleName());
        buf.append(':').append(Sys.getHostId());
        buf.append(':').append(this.getMaxConnections());
        BAbsTime ex = this.getExpiration();
        if (!ex.isNull()) {
            buf.append(':').append(ex.getDay());
            buf.append('-').append(ex.getMonth().getShortDisplayTag(null));
            buf.append('-').append(ex.getYear());
        }
        String s = buf.toString().trim();
        s = s.toUpperCase();
        s = s.replace('O', '0');
        return s;
    }
}

