/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr;

import com.ca.adr.BCadrNetwork;
import com.ca.adr.CadrConstants;
import com.ca.adr.CadrTarget;
import com.ca.adr.NiagaraBridge;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.event.BCadrEvents;
import com.ca.adr.event.BCadrSignal;
import com.ca.adr.message.DeviceConnectMessage;
import com.ca.adr.message.PollMessage;
import com.ca.adr.message.RequestEventMessage;
import com.ca.adr.point.BCadrPointDeviceExt;
import com.ca.adr.point.BCadrProxyExt;
import com.ca.adr.report.BCadrReports;
import com.ca.adr.util.BCadrMessageQueue;
import com.ca.adr.util.BCadrState;
import com.ca.adr.util.Base64Util;
import com.ca.adr.util.Logging;
import com.ca.adr.util.Message;
import com.ca.adr.util.MessageException;
import com.ca.adr.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class BCadrDevice
extends BDevice
implements CadrConstants,
Logging {
    public static final Property vtnAddress = BCadrDevice.newProperty((int)0, (String)"", null);
    public static final Property certificateAlias = BCadrDevice.newProperty((int)0, (String)"tridium", null);
    public static final Property vtnUser = BCadrDevice.newProperty((int)0, (String)"", null);
    public static final Property vtnPass = BCadrDevice.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property venId = BCadrDevice.newProperty((int)0, (String)"", null);
    public static final Property vtnId = BCadrDevice.newProperty((int)1, (String)"", null);
    public static final Property registrationId = BCadrDevice.newProperty((int)5, (String)"", null);
    public static final Property pollFrequency = BCadrDevice.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property toleranceRandom = BCadrDevice.newProperty((int)4, (double)0.0, null);
    public static final Property state = BCadrDevice.newProperty((int)67, (BValue)BCadrState.disconnected, null);
    public static final Property alertNewEvents = BCadrDevice.newProperty((int)0, (boolean)false, null);
    public static final Property alertClass = BCadrDevice.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property points = BCadrDevice.newProperty((int)0, (BValue)new BCadrPointDeviceExt(), null);
    public static final Property events = BCadrDevice.newProperty((int)0, (BValue)new BCadrEvents(), null);
    public static final Property messages = BCadrDevice.newProperty((int)4, (BValue)new BCadrMessageQueue(), null);
    public static final Property debugRequests = BCadrDevice.newProperty((int)0, (boolean)false, null);
    public static final Property debugResponses = BCadrDevice.newProperty((int)0, (boolean)false, null);
    public static final Action ping = BCadrDevice.newAction((int)4, null);
    public static final Action enable = BCadrDevice.newAction((int)16, null);
    public static final Action disable = BCadrDevice.newAction((int)16, null);
    public static final Action connect = BCadrDevice.newAction((int)20, null);
    public static final Action disconnect = BCadrDevice.newAction((int)20, null);
    public static final Action reconnect = BCadrDevice.newAction((int)20, null);
    public static final Action poll = BCadrDevice.newAction((int)4, null);
    public static final Action updateTargets = BCadrDevice.newAction((int)20, null);
    public static final Action refreshEvents = BCadrDevice.newAction((int)16, null);
    public static final Topic newEvent = BCadrDevice.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BCadrDevice.class);
    private BCadrNetwork network;
    private Clock.Ticket pollTicket;
    private boolean steady = false;
    private final HashSet targets = new HashSet();
    private boolean updating = false;
    private long updateTime;
    private Clock.Ticket updateTicket;

    public String getVtnAddress() {
        return this.getString(vtnAddress);
    }

    public void setVtnAddress(String v) {
        this.setString(vtnAddress, v, null);
    }

    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    public String getVtnUser() {
        return this.getString(vtnUser);
    }

    public void setVtnUser(String v) {
        this.setString(vtnUser, v, null);
    }

    public BPassword getVtnPass() {
        return (BPassword)this.get(vtnPass);
    }

    public void setVtnPass(BPassword v) {
        this.set(vtnPass, (BValue)v, null);
    }

    public String getVenId() {
        return this.getString(venId);
    }

    public void setVenId(String v) {
        this.setString(venId, v, null);
    }

    public String getVtnId() {
        return this.getString(vtnId);
    }

    public void setVtnId(String v) {
        this.setString(vtnId, v, null);
    }

    public String getRegistrationId() {
        return this.getString(registrationId);
    }

    public void setRegistrationId(String v) {
        this.setString(registrationId, v, null);
    }

    public BRelTime getPollFrequency() {
        return (BRelTime)this.get(pollFrequency);
    }

    public void setPollFrequency(BRelTime v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public double getToleranceRandom() {
        return this.getDouble(toleranceRandom);
    }

    public void setToleranceRandom(double v) {
        this.setDouble(toleranceRandom, v, null);
    }

    public BCadrState getState() {
        return (BCadrState)this.get(state);
    }

    public void setState(BCadrState v) {
        this.set(state, (BValue)v, null);
    }

    public boolean getAlertNewEvents() {
        return this.getBoolean(alertNewEvents);
    }

    public void setAlertNewEvents(boolean v) {
        this.setBoolean(alertNewEvents, v, null);
    }

    public String getAlertClass() {
        return this.getString(alertClass);
    }

    public void setAlertClass(String v) {
        this.setString(alertClass, v, null);
    }

    public BCadrPointDeviceExt getPoints() {
        return (BCadrPointDeviceExt)this.get(points);
    }

    public void setPoints(BCadrPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BCadrEvents getEvents() {
        return (BCadrEvents)this.get(events);
    }

    public void setEvents(BCadrEvents v) {
        this.set(events, (BValue)v, null);
    }

    public BCadrMessageQueue getMessages() {
        return (BCadrMessageQueue)this.get(messages);
    }

    public void setMessages(BCadrMessageQueue v) {
        this.set(messages, (BValue)v, null);
    }

    public boolean getDebugRequests() {
        return this.getBoolean(debugRequests);
    }

    public void setDebugRequests(boolean v) {
        this.setBoolean(debugRequests, v, null);
    }

    public boolean getDebugResponses() {
        return this.getBoolean(debugResponses);
    }

    public void setDebugResponses(boolean v) {
        this.setBoolean(debugResponses, v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void reconnect() {
        this.invoke(reconnect, null, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public void updateTargets() {
        this.invoke(updateTargets, null, null);
    }

    public void refreshEvents() {
        this.invoke(refreshEvents, null, null);
    }

    public void fireNewEvent(BCadrEvent event) {
        this.fire(newEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(CadrTarget tgt) {
        HashSet hashSet = this.targets;
        synchronized (hashSet) {
            this.targets.add(tgt);
        }
        this.scheduleUpdate(System.currentTimeMillis() + 3000L);
    }

    public void atSteadyState() throws Exception {
        this.steady = this.isRunning() && !this.getStatus().isFault();
        this.scheduleUpdate(System.currentTimeMillis() + 3000L);
        this.ping();
        super.atSteadyState();
    }

    public void cancelPoll() {
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
        this.pollTicket = null;
    }

    public void cancelReports() {
    }

    public void changed(Property p, Context c) {
        if (c != Context.decoding && this.isRunning()) {
            if (p.equals(status)) {
                if (this.isDown() || this.isDisabled() || this.isFault() || this.isFatalFault()) {
                    if (this.getState().isEngaged()) {
                        this.disconnect();
                    }
                } else if (this.getState().isDisengaged()) {
                    this.connect();
                }
            } else if (p.equals(vtnAddress)) {
                this.reconnect();
            } else if (p.equals(pollFrequency) && this.pollTicket != null) {
                this.schedulePoll();
            }
        }
        super.changed(p, c);
    }

    public void configFailure(String message) {
        this.doDisconnect();
        this.steady = false;
        this.configFail(message);
    }

    public void configSuccess() {
        this.steady = this.isRunning() && Sys.atSteadyState();
        this.configOk();
    }

    public void doConnect() {
        if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault() || !this.steady) {
            return;
        }
        this.setState(BCadrState.connecting);
        this.enqueue(new DeviceConnectMessage(this));
    }

    public void doDisconnect() {
        this.cancelPoll();
        if (this.trace()) {
            this.trace(this.toPathString() + " disconnect");
        }
        this.setState(BCadrState.disconnected);
        this.getHealth().setDown(true);
    }

    public void doDisable() {
        this.setEnabled(false);
    }

    public void doEnable() {
        this.setEnabled(true);
    }

    public void doPing() {
        if (!this.steady) {
            return;
        }
        if (this.getState().isDisconnected()) {
            this.connect();
        }
    }

    public void doPoll() {
        if (this.is2b()) {
            this.enqueue(new PollMessage(this));
        } else {
            this.enqueue(new RequestEventMessage(this));
        }
    }

    public void doReconnect() {
        this.doDisconnect();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connect();
    }

    public void doRefreshEvents() {
        this.enqueue(new RequestEventMessage(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateTargets() {
        BCadrEvent evt;
        long tmp;
        ArrayList tgts;
        if (!this.isRunning()) {
            return;
        }
        BCadrDevice bCadrDevice = this;
        synchronized (bCadrDevice) {
            if (this.updating) {
                return;
            }
            this.updating = true;
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
        }
        List evts = this.updateEvents();
        HashSet hashSet = this.targets;
        synchronized (hashSet) {
            tgts = new ArrayList(this.targets);
        }
        int evtsLen = evts.size();
        long now = System.currentTimeMillis();
        long next = now + 3600000L;
        if (evtsLen > 0 && (tmp = (evt = (BCadrEvent)evts.get(0)).nextUpdate(now)) > 0L && tmp < next) {
            next = tmp;
        }
        int ilen = this.targets.size();
        for (int i = 0; i < ilen; ++i) {
            boolean match = false;
            CadrTarget tgt = (CadrTarget)tgts.get(i);
            for (Object o : evts) {
                evt = (BCadrEvent)o;
                try {
                    BCadrSignal sig;
                    if (!tgt.acceptsMarketContext(evt.getProgram()) || !tgt.accepts(evt.getTargets()) || !tgt.accepts(evt.getTargets()) || (sig = this.getSignalForTarget(tgt, evt.getSignals())) == null) continue;
                    tgt.cadrUpdate(sig);
                    match = true;
                    break;
                }
                catch (Exception x) {
                    if (tgt instanceof BCadrProxyExt) {
                        ((BCadrProxyExt)tgt).readFail(x.toString());
                        continue;
                    }
                    this.error(this.toPathString(), x);
                }
            }
            if (match) continue;
            try {
                tgt.cadrUpdate(null);
                continue;
            }
            catch (Exception x) {
                if (tgt instanceof BCadrProxyExt) {
                    ((BCadrProxyExt)tgt).readFail(x.toString());
                    continue;
                }
                this.error(this.toPathString(), x);
            }
        }
        now = System.currentTimeMillis();
        if (next < now) {
            this.scheduleUpdate(now + 3000L);
        } else {
            this.scheduleUpdate(next);
        }
        BCadrDevice bCadrDevice2 = this;
        synchronized (bCadrDevice2) {
            this.updating = false;
        }
    }

    public BCadrReports getReports() {
        return null;
    }

    public void enqueue(Runnable r) {
        if (r instanceof Message) {
            this.getMessages().enqueue((Message)r);
        } else {
            this.getCadrNetwork().enqueue(r);
        }
    }

    public BCadrNetwork getCadrNetwork() {
        if (this.network == null) {
            for (BComplex cur = this.getParent(); cur != null; cur = cur.getParent()) {
                if (!(cur instanceof BCadrNetwork)) continue;
                this.network = (BCadrNetwork)cur;
                break;
            }
        }
        return this.network;
    }

    public BCadrEvent getEvent(String eventId, boolean create) {
        String name = SlotPath.escape((String)eventId);
        BCadrEvent ret = (BCadrEvent)this.getEvents().get(name);
        if (ret == null) {
            if (!create) {
                return null;
            }
            ret = new BCadrEvent();
            ret.setEventId(eventId);
            this.getEvents().add(name, (BValue)ret);
        }
        return ret;
    }

    public BIcon getIcon() {
        return icnVen;
    }

    public Type getNetworkType() {
        return BCadrNetwork.TYPE;
    }

    public boolean is2b() {
        return false;
    }

    public void pingOk() {
        super.pingOk();
        this.getCadrNetwork().pingOk();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public IFuture postPing() {
        try {
            this.doPing();
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
        return null;
    }

    public XElem postXml(String svc, XElem msg) throws Exception {
        String addr;
        int idx;
        if (this.getVtnAddress().length() == 0) {
            this.configFail("Unconfigured VtnAddress");
            throw new MessageException("Empty VtnAddress");
        }
        if (this.getStatus().isFault()) {
            this.configOk();
        }
        if ((idx = (addr = this.getVtnAddress()).indexOf("/OpenADR2/Simple/")) > 0) {
            addr = addr.substring(0, idx);
        }
        addr = Strings.concatUris(addr, svc);
        msg = this.post(addr, msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(CadrTarget tgt) {
        HashSet hashSet = this.targets;
        synchronized (hashSet) {
            this.targets.remove(tgt);
        }
    }

    public void schedulePoll() {
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getPollFrequency(), (Action)poll, null);
    }

    public synchronized void scheduleUpdate(long when) {
        if (!Sys.atSteadyState()) {
            return;
        }
        if (this.updateTicket != null) {
            if (when < this.updateTime) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            } else {
                return;
            }
        }
        this.updateTime = when;
        this.updateTicket = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((long)when), (Action)updateTargets, null);
    }

    public void sendAlert(BCadrEvent evt) throws Exception {
        BAlarmRecord rec = new BAlarmRecord();
        rec.setTimestamp(Clock.time());
        rec.setSource(BOrdList.make((BOrd)evt.getSlotPathOrd()));
        String ac = BFormat.format((String)this.getAlertClass(), (Object)this);
        rec.setAlarmClass(ac);
        rec.setSourceState(BSourceState.alert);
        rec.setAckRequired(false);
        rec.setLastUpdate(Clock.time());
        rec.addAlarmFacet("start", (BIDataValue)evt.getStart());
        rec.addAlarmFacet("duration", (BIDataValue)evt.getDuration());
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        evt.prettyPrint(out);
        rec.addAlarmFacet("msgText", (BIDataValue)BString.make((String)str.toString()));
        try {
            BAlarmService svc = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            if (svc.isRunning()) {
                svc.routeAlarm(rec);
            }
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
    }

    public void started() throws Exception {
        if (this.getToleranceRandom() == 0.0) {
            Random r = new Random(Clock.ticks());
            this.setToleranceRandom(r.nextDouble());
        }
        this.setState(BCadrState.disconnected);
        this.getHealth().setDown(true);
        this.getCadrNetwork().addConnection();
        super.started();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void stopped() throws Exception {
        this.doDisconnect();
        this.getCadrNetwork().removeConnection();
        this.network = null;
        super.stopped();
    }

    public String toString(Context cx) {
        String str = this.getFaultCause();
        if (str.length() > 0) {
            return str;
        }
        if (this.isRunning()) {
            return this.getNetwork().getDisplayName(cx) + "-" + this.getDisplayName(cx);
        }
        return super.toString(cx);
    }

    public HashSet unfinishedEvents() {
        BCadrEvent[] kids;
        HashSet<BCadrEvent> ret = new HashSet<BCadrEvent>();
        long now = System.currentTimeMillis();
        for (BCadrEvent kid : kids = (BCadrEvent[])this.getEvents().getChildren(BCadrEvent.class)) {
            if (kid.updateState(now).isFinished()) continue;
            ret.add(kid);
        }
        return ret;
    }

    public List updateEvents() {
        BCadrEvent[] kids;
        ArrayList<BCadrEvent> bucket = new ArrayList<BCadrEvent>();
        long now = System.currentTimeMillis();
        for (BCadrEvent kid : kids = (BCadrEvent[])this.getEvents().getChildren(BCadrEvent.class)) {
            if (kid.updateState(now).isFinished()) continue;
            bucket.add(kid);
        }
        bucket.sort(new NextUpdateComparator(now));
        return bucket;
    }

    protected BCadrSignal getSignalForTarget(CadrTarget target, List list) {
        try {
            int len = list.size();
            if (len == 0) {
                return null;
            }
            int i = len;
            while (--i >= 0) {
                BCadrSignal sig = (BCadrSignal)list.get(i);
                if (!target.acceptsSignal(sig.getSignalName(), sig.getSignalType()) || !target.accepts(sig.getTargets())) continue;
                return sig;
            }
        }
        catch (Exception x) {
            this.error(this.toPathString(), x);
        }
        return null;
    }

    protected XElem post(String addr, XElem msg) throws Exception {
        if (this.getVtnUser().trim().isEmpty()) {
            return this.postTridium(addr, msg);
        }
        return this.postJava(addr, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XElem postJava(String addr, XElem msg) throws Exception {
        XElem ret;
        if (this.getDebugRequests()) {
            System.out.println("REQUEST: " + this.toPathString() + " - " + addr);
            msg.dump();
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(addr).openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/xml;charset=utf-8");
        conn.setChunkedStreamingMode(8000);
        if (!this.getVtnUser().equals("")) {
            conn.setRequestProperty("Authorization", "Basic " + this.getAuth());
        }
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)conn;
            SSLSocketFactory fac = https.getSSLSocketFactory();
            https.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        XWriter xout = null;
        try {
            xout = new XWriter(conn.getOutputStream());
            msg.write(xout);
            xout.close();
            xout = null;
            int rc = conn.getResponseCode();
            if (rc < 199 || rc >= 400) {
                throw new IOException("Server returned HTTP response code: " + rc);
            }
        }
        catch (Exception x) {
            if (xout != null) {
                try {
                    xout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getDebugResponses()) {
                try (InputStream is = conn.getInputStream();){
                    System.out.println("ERROR RESPONSE: " + this.toPathString());
                    int ch = is.read();
                    while (ch >= 0) {
                        System.out.print((char)ch);
                        ch = is.read();
                    }
                    System.out.println();
                }
            }
            throw x;
        }
        try (InputStream in = conn.getInputStream();){
            XParser xin = XParser.make((InputStream)in);
            ret = xin.parse(true);
            if (this.getDebugResponses()) {
                System.out.println("RESPONSE: " + this.toPathString());
                ret.dump();
            }
        }
        finally {
            try {
                conn.disconnect();
            }
            catch (Exception x) {
                this.debug(this.toPathString(), x);
            }
        }
        return ret;
    }

    protected XElem postTridium(String addr, XElem msg) throws Exception {
        HttpConnection conn;
        URL url = new URL(addr);
        if (this.getDebugRequests()) {
            System.out.println("REQUEST: " + this.toPathString() + " - " + url);
            msg.dump();
        }
        BIpHost host = new BIpHost(url.getHost());
        int port = url.getPort();
        String uri = url.getFile();
        if (addr.toLowerCase().startsWith("https")) {
            SocketFactory fac;
            if (port < 0) {
                port = 443;
            }
            ICryptoManager mgr = CertManagerFactory.getInstance();
            try {
                ClientTlsParameters tlsParms = this.getCertificateAlias().trim().length() > 0 ? new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol(), this.getCertificateAlias()) : new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol());
                fac = (SSLSocketFactory)mgr.getClientSocketFactory(tlsParms);
                conn = new HttpsConnection((BHost)host, port, uri, fac);
            }
            catch (Throwable t) {
                fac = mgr.getClientSocketFactory(BSslTlsEnum.tlsv1_2);
                conn = new HttpsConnection((BHost)host, port, uri, fac);
            }
        } else {
            if (port < 0) {
                port = 80;
            }
            conn = new HttpConnection((BHost)host, port, uri);
        }
        try {
            if (!this.getVtnUser().equals("")) {
                conn.setRequestHeader("Authorization", "Basic " + this.getAuth());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XWriter out = new XWriter((OutputStream)baos);
            msg.write(out);
            out.close();
            byte[] data = baos.toByteArray();
            conn.setRequestMethod("POST");
            conn.setRequestHeader("Content-Length", data.length);
            conn.setRequestHeader("Content-Type", "application/xml;charset=utf-8");
            int rc = conn.connect((long)data.length, (InputStream)new ByteArrayInputStream(data));
            if (rc < 199 || rc >= 400) {
                throw new IOException("Server returned HTTP response code: " + rc);
            }
        }
        catch (Exception x) {
            if (this.getDebugResponses()) {
                InputStream is = conn.getInputStream();
                System.out.println("ERROR RESPONSE: " + this.toPathString());
                int ch = is.read();
                while (ch >= 0) {
                    System.out.print((char)ch);
                    ch = is.read();
                }
                System.out.println();
            }
            throw x;
        }
        XParser in = XParser.make((InputStream)conn.getInputStream());
        XElem ret = in.parse(true);
        if (this.getDebugResponses()) {
            System.out.println("RESPONSE: " + this.toPathString());
            ret.dump();
        }
        try {
            conn.close();
        }
        catch (Exception x) {
            this.debug(this.toPathString(), x);
        }
        return ret;
    }

    private String getAuth() {
        String authorization = this.getVtnUser() + ":" + NiagaraBridge.getPass(this.getVtnPass());
        return Base64Util.encode(authorization.getBytes(), true);
    }

    static class NextUpdateComparator
    implements Comparator {
        final long time;

        NextUpdateComparator(long time) {
            this.time = time;
        }

        public int compare(Object o1, Object o2) {
            BCadrEvent e1 = (BCadrEvent)o1;
            BCadrEvent e2 = (BCadrEvent)o2;
            long n1 = e1.nextUpdate(this.time);
            long n2 = e2.nextUpdate(this.time);
            return Long.compare(n1, n2);
        }
    }
}

