/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import com.ca.adr.CadrConstants;
import com.ca.adr.event.BCadrEvent;
import com.ca.adr.util.Strings;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

class Ui
implements CadrConstants {
    public static final BImage imgEvt = BImage.make((BIcon)icnEvt);
    public static final BImage imgIvl = BImage.make((BIcon)icnIvl);
    public static final BImage imgSgl = BImage.make((BIcon)icnSgl);
    private static final Lexicon lex = Lexicon.make(BCadrEvent.class);

    Ui() {
    }

    static void errDialog(BWidget parent, String message, Throwable err) {
        BDialog.open((BWidget)parent, (String)"Error", (Object)message, (int)1, (BImage)BDialog.ERROR_ICON, (Throwable)err);
    }

    static Command hyperlink(BWidget owner, String label, BIcon icon, BOrd o) {
        return new HyperlinkCommand(owner, label, BImage.make((BIcon)icon), o);
    }

    static String lex(String key) {
        String ret = lex.getText(key);
        if (ret == null || ret.length() == 0 || ret.equals(key)) {
            int idx = key.lastIndexOf(46);
            if (idx > 0) {
                key = key.substring(++idx);
            }
            return Strings.toFriendly((String)key);
        }
        return ret;
    }

    static BBorderPane style(BBorderPane pane) {
        BBorder border = BBorder.make((int)1);
        pane.setBorder(border);
        return pane;
    }

    static BBorderPane style(BBorderPane pane, boolean top, boolean right, boolean bottom, boolean left) {
        int styled = 1;
        int unstyled = 0;
        BBrush brush = BBrush.DEFAULT;
        BBrush nobrush = BBrush.NULL;
        boolean tw = top;
        boolean rw = right;
        boolean bw = bottom;
        boolean lw = left;
        int ts = top ? styled : unstyled;
        int rs = right ? styled : unstyled;
        int bs = bottom ? styled : unstyled;
        int ls = left ? styled : unstyled;
        BBrush tb = top ? brush : nobrush;
        BBrush rb = right ? brush : nobrush;
        BBrush bb = bottom ? brush : nobrush;
        BBrush lb = left ? brush : nobrush;
        BBorder border = BBorder.make((double)((double)tw), (int)ts, (BBrush)tb, (double)((double)rw), (int)rs, (BBrush)rb, (double)((double)bw), (int)bs, (BBrush)bb, (double)((double)lw), (int)ls, (BBrush)lb);
        pane.setBorder(border);
        return pane;
    }

    static BButton makeToolButton(Command cmd) {
        return Ui.style(new BButton(cmd));
    }

    static BButton style(BButton button) {
        button.setButtonStyle(BButtonStyle.toolBar);
        button.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        return button;
    }

    private static class HyperlinkCommand
    extends Command {
        final BOrd ord;

        HyperlinkCommand(BWidget owner, String label, BImage icon, BOrd ord) {
            super(owner, label, icon, null, null);
            this.ord = ord;
        }

        public CommandArtifact doInvoke() {
            BWbShell shell = (BWbShell)this.getOwner().getShell();
            shell.hyperlink(this.ord);
            return null;
        }
    }
}

