/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import com.ca.adr.BCadrObject;
import com.ca.adr.CadrConstants;
import com.ca.adr.point.BCadrProxyExt;
import com.ca.adr.report.BCadrReport;
import com.ca.adr.ui.Ui;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.control.BPointExtension;
import javax.baja.driver.BDeviceExt;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderModel;

public class Shortcuts
extends MgrColumn {
    static final BBrush bg = BBrush.makeSolid((BColor)BColor.white);
    static final BImage defIcon = BImage.make((String)"module://icons/x16/object.png");
    static final BImage magIcn = BImage.make((String)"module://icons/x16/magnifyingGlass.png");
    static final BImage propIcn = BImage.make((String)"module://icons/x16/views/propertySheet.png");
    static final String PROP_SHEET = "view:workbench:PropertySheet";
    FolderModel folderModel;
    TableCellRenderer renderer = null;
    final Hashtable targets = new Hashtable();

    public Shortcuts() {
        super(Ui.lex("links"), 0);
    }

    public Object get(Object row) {
        return row;
    }

    public TableCellRenderer getCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new CellRenderer();
            MgrModel model = this.getManager().getModel();
            if (model instanceof FolderModel) {
                this.folderModel = (FolderModel)model;
            }
        }
        return this.renderer;
    }

    void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        BWbShell shell;
        RectGeom rect = table.getCellBounds(row, col);
        BComponent component = table.getComponentAt(row);
        Target[] t = (Target[])this.targets.get(component);
        if (t == null) {
            return;
        }
        int x = (int)(event.getX() - rect.x);
        int i = (x - 4) / 20;
        BOrd ord = t[i].ord;
        if (ord != null && (shell = table.getManager().getWbShell()) != null) {
            shell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)ord), (BInputEvent)event));
        }
    }

    protected Target[] getTargets(BComponent cellValue) {
        ArrayList<Target> res = new ArrayList<Target>();
        if (cellValue instanceof BCadrReport) {
            res.add(new Target(propIcn, BOrd.make((BOrd)cellValue.getNavOrd(), (String)PROP_SHEET)));
        } else if (cellValue instanceof BCadrObject) {
            res.add(new Target(propIcn, BOrd.make((BOrd)cellValue.getNavOrd(), (String)PROP_SHEET)));
            res.add(new Target(magIcn, cellValue.getNavOrd()));
        } else {
            BComponent[] kids;
            res.add(new Target(magIcn, cellValue.getNavOrd()));
            for (BComponent bComponent : kids = cellValue.getChildComponents()) {
                BComponent kid = null;
                if (bComponent instanceof BDeviceExt) {
                    kid = bComponent;
                } else if (bComponent instanceof BCadrProxyExt) {
                    kid = bComponent;
                    BCadrProxyExt ext = (BCadrProxyExt)bComponent;
                    BOrd signal = ext.getSignal();
                    if (!signal.isNull()) {
                        res.add(new Target(BImage.make((BIcon)CadrConstants.icnSgl), signal));
                    }
                } else if (bComponent instanceof BPointExtension) {
                    kid = bComponent;
                } else if (bComponent instanceof BCadrObject) {
                    kid = bComponent;
                }
                if (kid == null) continue;
                BIcon icn = kid.getIcon();
                if (icn.isNull()) {
                    res.add(new Target(defIcon, kid.getNavOrd()));
                    continue;
                }
                res.add(new Target(BImage.make((BIcon)icn), kid.getNavOrd()));
            }
        }
        Target[] ret = new Target[res.size()];
        res.toArray(ret);
        return ret;
    }

    static class Target {
        final BImage icon;
        final BOrd ord;

        Target(BImage icon, BOrd ord) {
            this.icon = icon;
            this.ord = ord;
        }
    }

    private class CellRenderer
    extends ComponentTableCellRenderer {
        private CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent row;
            if (Shortcuts.this.folderModel != null && (row = (BComponent)cell.value).getType().is(Shortcuts.this.folderModel.getFolderType())) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            Target[] t = (Target[])Shortcuts.this.targets.get(cell.value);
            if (t == null) {
                t = Shortcuts.this.getTargets((BComponent)cell.value);
                Shortcuts.this.targets.put(cell.value, t);
            }
            return 4 + t.length * 20 + 4;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            Target[] t = (Target[])Shortcuts.this.targets.get(cell.value);
            if (t == null) {
                t = Shortcuts.this.getTargets((BComponent)cell.value);
                Shortcuts.this.targets.put(cell.value, t);
            }
            int len = t.length;
            for (int i = 0; i < len; ++i) {
                g.drawImage(t[i].icon, (double)(4 + i * 20), (cell.height - 16.0) / 2.0);
            }
        }

        protected BComponentTable getComponentTable() {
            return Shortcuts.this.getManager().getModel().getTable();
        }
    }
}

