/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import java.util.ArrayList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

class PropPathColumn
extends MgrColumn {
    private final String[] propPath;
    private Type propType;

    public PropPathColumn(String colName, String propPath, int flags) {
        super(colName, flags);
        this.propPath = this.split(propPath);
    }

    public PropPathColumn(String colName, String[] propPath, int flags) {
        super(colName, flags);
        this.propPath = propPath;
    }

    public PropPathColumn(String colName, String[] propPath, Type propType, int flags) {
        super(colName, flags);
        this.propPath = propPath;
        this.propType = propType;
    }

    public Object get(Object row) {
        return this.getValue((BComplex)row);
    }

    public BValue load(MgrEditRow row) {
        BValue v = this.getValue((BComplex)row.getTarget());
        if (v == null) {
            return null;
        }
        return v.newCopy();
    }

    public void save(MgrEditRow row, BValue value, Context cx) {
        if (!this.isMatch((BComplex)row.getTarget())) {
            return;
        }
        BComplex parent = this.getParent((BComplex)row.getTarget());
        Property prop = this.getProperty((BComplex)row.getTarget(), parent);
        if (prop == null) {
            return;
        }
        parent.set(prop, value, cx);
    }

    public String toDisplayString(Object row, Object value, Context cx) {
        if (value == null) {
            return "-";
        }
        if (value instanceof BObject) {
            return ((BObject)value).toString(cx);
        }
        return value.toString();
    }

    public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
        BValue v = null;
        BFacets slotFacets = null;
        for (MgrEditRow row : rows) {
            BComponent target = row.getTarget();
            if (!this.isMatch((BComplex)target)) {
                return null;
            }
            if (v != null) continue;
            BComplex parent = this.getParent((BComplex)target);
            Property prop = this.getProperty((BComplex)target, parent);
            v = row.getCell(colIndex);
            slotFacets = parent.getSlotFacets((Slot)prop);
        }
        if (currentEditor == null) {
            currentEditor = BWbFieldEditor.makeFor(v, slotFacets);
        }
        currentEditor.loadValue((BObject)v.newCopy(), slotFacets);
        return currentEditor;
    }

    public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
        BWbFieldEditor editor = (BWbFieldEditor)widget;
        BValue val = (BValue)editor.saveValue();
        for (MgrEditRow row : rows) {
            row.setCell(colIndex, val.newCopy());
        }
    }

    private BComplex getParent(BComplex row) {
        BComplex ret = row;
        int len = this.propPath.length - 1;
        for (int i = 0; i < len; ++i) {
            if ((ret = (BComplex)ret.get(this.propPath[i])) != null) continue;
            return null;
        }
        return ret;
    }

    private Property getProperty(BComplex row, BComplex parent) {
        return parent.getProperty(this.propPath[this.propPath.length - 1]);
    }

    private BValue getValue(BComplex row) {
        BComplex parent = this.getParent(row);
        if (parent == null) {
            return null;
        }
        return parent.get(this.propPath[this.propPath.length - 1]);
    }

    private boolean isMatch(BComplex row) {
        if (this.getValue(row) == null) {
            return false;
        }
        if (this.propType == null) {
            return true;
        }
        BValue ret = this.getValue(row);
        return ret.getType().is(this.propType);
    }

    private String[] split(String s) {
        if (s.indexOf(47) < 0) {
            return new String[]{s};
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '/') {
                if (buf.length() <= 0) continue;
                list.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }
}

