/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import com.ca.adr.CadrConstants;
import com.ca.adr.point.BCadrPointDiscoveryJob;
import com.ca.adr.point.BCadrPointDiscoveryResult;
import com.ca.adr.point.BCadrProxyExt;
import com.ca.adr.ui.BCadrPointManager;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class CadrPointLearn
extends MgrLearn
implements CadrConstants {
    private BCadrPointDiscoveryJob job;

    public CadrPointLearn(BCadrPointManager mgr) {
        super((BAbstractManager)mgr);
    }

    public BImage getIcon(Object discovered) {
        BCadrPointDiscoveryResult res = CadrPointLearn.x(discovered);
        String str = res.getSignalType();
        BIcon icn = str.startsWith("price") ? icnPrice : (str.equals("level") ? icnSgl : icnPower);
        return BImage.make((BIcon)icn);
    }

    public BCadrPointDiscoveryJob getCadrJob() {
        return this.job;
    }

    public boolean isExisting(Object discovered, BComponent db) {
        BCadrPointDiscoveryResult res = CadrPointLearn.x(discovered);
        if (db instanceof BControlPoint) {
            if (db.get("proxyExt") instanceof BCadrProxyExt) {
                return false;
            }
            BCadrProxyExt ext = CadrPointLearn.ext(db);
            if (!ext.getSignalNames().equals(res.getSignalName())) {
                return false;
            }
            return ext.getSignalTypes().equals(res.getSignalType());
        }
        return false;
    }

    public boolean isMatchable(Object discovered, BComponent db) {
        if (db instanceof BControlPoint) {
            return db.get("proxyExt") instanceof BCadrProxyExt;
        }
        return false;
    }

    public void jobComplete(BJob j) {
        j.lease(Integer.MAX_VALUE);
        this.job = (BCadrPointDiscoveryJob)j;
        this.updateRoots(this.job.getResults().getChildComponents());
    }

    public void setCadrJob(BCadrPointDiscoveryJob job) {
        this.job = job;
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BCadrPointDiscoveryResult res = CadrPointLearn.x(discovered);
        BCadrPointManager.Model m = (BCadrPointManager.Model)this.getManager().getModel();
        row.setName(res.getName());
        row.setCell(m.sigName, res.get("signalName"));
        row.setCell(m.sigType, res.get("signalType"));
        if (!res.getFacets().equals((Object)BFacets.NULL)) {
            row.setCell(m.deviceFacets, (BValue)res.getFacets());
            row.setCell(m.facets, (BValue)res.getFacets());
        }
    }

    public MgrTypeInfo[] toTypes(Object discovered) {
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE)};
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BCadrPointDiscoveryResult.signalName), new MgrColumn.Prop(BCadrPointDiscoveryResult.signalType), new MgrColumn.Prop(BCadrPointDiscoveryResult.facets)};
    }

    private static BCadrProxyExt ext(Object o) {
        return (BCadrProxyExt)((BControlPoint)o).getProxyExt();
    }

    private static BCadrPointDiscoveryResult x(Object discovered) {
        return (BCadrPointDiscoveryResult)discovered;
    }
}

