/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import com.ca.adr.ui.BCadrTargetsFE;
import com.ca.adr.ui.Ui;
import com.ca.adr.util.BCadrEventTargets;
import com.ca.adr.util.BCadrTargets;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;

public class BCadrTargetsEditor
extends BEdgePane {
    public static final Action setModified = BCadrTargetsEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCadrTargetsEditor.class);
    private static final BImage imgAdd = BImage.make((BIcon)BIcon.std((String)"add.png"));
    private static final BImage imgDelete = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    BButton butAdd;
    BButton butDelAll;
    boolean eventTargets = true;
    boolean is2b = true;
    boolean modified = false;
    boolean readonly;
    final ArrayList rows = new ArrayList();
    BGridPane table;
    BCadrTargets targets;

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCadrTargetsEditor() {
    }

    public BCadrTargetsEditor(BCadrTargets targets, boolean is2b, boolean readonly) {
        this.targets = targets;
        this.eventTargets = targets instanceof BCadrEventTargets;
        this.is2b = is2b;
        this.readonly = readonly;
        BConstrainedPane cp = new BConstrainedPane();
        cp.setMinHeight(300.0);
        cp.setMinWidth(500.0);
        cp.setContent(this.makeTable());
        this.setCenter((BWidget)cp);
        ArrayList entries = targets.getAllEntries(new ArrayList());
        for (Object entry : entries) {
            BCadrTargets.Entry e = (BCadrTargets.Entry)entry;
            this.addRow(e.getKey(), e.getValue());
        }
        this.rows.sort(new RowComparator());
        this.setTop(this.makeButtons());
        this.drawTable();
    }

    public void add() {
        if (this.eventTargets) {
            this.addRow("groupID", "");
        } else {
            this.addRow("endDeviceAsset", "");
        }
        this.modified = true;
        this.drawTable();
    }

    public void deleteAll() {
        if (this.rows.size() == 0) {
            return;
        }
        this.rows.clear();
        this.modified = true;
        this.drawTable();
    }

    public void delete(Row row) {
        int i = this.rows.size();
        while (--i >= 0) {
            if (this.rows.get(i) != row) continue;
            this.rows.remove(i);
            this.modified = true;
            break;
        }
        this.drawTable();
    }

    public void doSetModified() {
        this.modified = true;
    }

    protected static BCadrTargets open(BCadrTargetsFE fe, boolean is2b, boolean readonly) {
        BCadrTargets value;
        BCadrTargetsEditor ed;
        String title = ed.eventTargets ? Ui.lex("eventTargets") : Ui.lex("signalTargets");
        int res = BDialog.open((BWidget)fe, (String)title, (Object)((Object)(ed = new BCadrTargetsEditor(value = fe.getTargets(), is2b, readonly))), (int)3);
        if (res == 1) {
            value = ed.save();
        }
        return value;
    }

    protected BCadrTargets save() {
        if (!this.modified) {
            return this.targets;
        }
        BCadrTargets ret = this.targets.getNull();
        this.rows.sort(new RowComparator());
        for (Object row : this.rows) {
            Row r = (Row)row;
            if (r.key.getSelectedIndex() < 0) continue;
            ret = ret.add(r.key.getSelectedItem().toString(), r.val.getText());
        }
        return ret;
    }

    private void addRow(String key, String value) {
        Row r = new Row(this, key, value);
        this.rows.add(r);
        this.linkTo((BComponent)r.key, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo((BComponent)r.val.getEditor(), (Slot)BTextField.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)r.val.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)r.val, (Slot)BTextDropDown.listActionPerformed, (Slot)setModified);
    }

    private void drawTable() {
        this.table.removeAll();
        for (Object row : this.rows) {
            Row r = (Row)row;
            this.table.add(null, (BValue)r.del);
            this.table.add(null, (BValue)r.key);
            this.table.add(null, (BValue)new BLabel(" = "));
            this.table.add(null, (BValue)r.val);
        }
    }

    private void load(Row row, String key, String val) {
        BList list = row.key.getList();
        if (this.eventTargets) {
            list.addItem((Object)"groupID");
            list.addItem((Object)"partyID");
            list.addItem((Object)"resourceID");
            list.addItem((Object)"venID");
            if (this.is2b) {
                list.addItem((Object)"endDeviceAsset");
                list.addItem((Object)"meterAsset");
                list.addItem((Object)"pointOfDelivery");
                list.addItem((Object)"pointOfReceipt");
                list.addItem((Object)"aggregatedPnode");
                list.addItem((Object)"pnode");
                list.addItem((Object)"serviceDeliveryPoint");
            }
        } else {
            list.addItem((Object)"endDeviceAsset");
        }
        list.setSelectedItem((Object)key);
        if (list.getSelectedIndex() < 0) {
            list.addItem((Object)key);
            list.setSelectedItem((Object)key);
        }
        list = row.val.getList();
        list.addItem((Object)"*");
        list.addItem((Object)"Baseboard_Header");
        list.addItem((Object)"Electric_Vehicle");
        list.addItem((Object)"Energy_Management_System");
        list.addItem((Object)"EVSE");
        list.addItem((Object)"Exterior_Lighting");
        list.addItem((Object)"Generation_Systems");
        list.addItem((Object)"Hot_tub");
        list.addItem((Object)"Interior_Lighting");
        list.addItem((Object)"Irrigation_Pump");
        list.addItem((Object)"Load_Control_Switch");
        list.addItem((Object)"Managed_Commercial_and_Industrial_Loads");
        list.addItem((Object)"Pool_Pump");
        list.addItem((Object)"RESU");
        list.addItem((Object)"Sauna");
        list.addItem((Object)"Simple_Residential_On_Off_Loads");
        list.addItem((Object)"Smart_Appliance");
        list.addItem((Object)"Smart_Energy_Module");
        list.addItem((Object)"Smart_Inverter");
        list.addItem((Object)"Storage");
        list.addItem((Object)"Strip_Heater");
        list.addItem((Object)"Thermostat");
        list.addItem((Object)"Water_Heater");
        list.addItem((Object)"x-{CUSTOM}");
        if (list.indexOfItem((Object)val) < 0) {
            list.addItem((Object)val);
        }
        row.val.setText(val);
    }

    private BWidget makeButtons() {
        this.butAdd = Ui.makeToolButton(new CmdAdd());
        this.butAdd.setEnabled(!this.readonly);
        this.butDelAll = Ui.makeToolButton(new CmdDeleteAll());
        this.butDelAll.setEnabled(!this.readonly);
        BFlowPane fp = new BFlowPane(BHalign.left);
        fp.add(null, (BValue)this.butAdd);
        fp.add(null, (BValue)this.butDelAll);
        return new BBorderPane((BWidget)fp, 3.0, 0.0, 3.0, 0.0);
    }

    private BWidget makeTable() {
        this.table = new BGridPane(4);
        this.table.setHalign(BHalign.left);
        this.table.setValign(BValign.top);
        this.table.setRowGap(0.0);
        BBorderPane bp = new BBorderPane((BWidget)this.table, 2.0, 0.0, 0.0, 0.0);
        return new BScrollPane((BWidget)bp);
    }

    static class RowComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String r1 = (String)((Row)o1).key.getSelectedItem();
            String r2 = (String)((Row)o2).key.getSelectedItem();
            if (r1 == null) {
                if (r2 == null) {
                    return 0;
                }
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return r1.compareTo(r2);
        }
    }

    static class Row {
        public final BListDropDown key;
        public final BTextDropDown val;
        public final BButton del;

        public Row(BCadrTargetsEditor ed, String k, String v) {
            boolean ro = ed.readonly;
            this.key = new BListDropDown();
            this.key.setEnabled(!ro);
            this.val = new BTextDropDown(40, !ro);
            this.val.setEnabled(!ro);
            ed.load(this, k, v);
            this.del = new BButton((Command)new CmdDelete(ed, this), false, true);
            this.del.setEnabled(!ro);
            this.del.setButtonStyle(BButtonStyle.toolBar);
            this.del.setBackground(BBrush.makeImage((BImage)BImage.NULL));
        }
    }

    private class CmdDeleteAll
    extends Command {
        CmdDeleteAll() {
            super((BWidget)BCadrTargetsEditor.this, Ui.lex("clearAll"), imgDelete, null, null);
        }

        public CommandArtifact doInvoke() {
            BCadrTargetsEditor.this.deleteAll();
            return null;
        }
    }

    static class CmdDelete
    extends Command {
        final BCadrTargetsEditor ed;
        final Row row;

        CmdDelete(BCadrTargetsEditor ed, Row row) {
            super((BWidget)ed, Ui.lex("delete"), imgDelete, null, null);
            this.ed = ed;
            this.row = row;
        }

        public CommandArtifact doInvoke() {
            this.ed.delete(this.row);
            return null;
        }
    }

    private class CmdAdd
    extends Command {
        CmdAdd() {
            super((BWidget)BCadrTargetsEditor.this, Ui.lex("new"), imgAdd, null, null);
        }

        public CommandArtifact doInvoke() {
            BCadrTargetsEditor.this.add();
            return null;
        }
    }
}

