/*
 * Decompiled with CFR 0.152.
 */
package com.ca.adr.ui;

import com.ca.adr.point.BCadrOptIn;
import com.ca.adr.point.BCadrOptOut;
import com.ca.adr.point.BCadrPointDiscoveryJob;
import com.ca.adr.point.BCadrPointFolder;
import com.ca.adr.point.BCadrProxyExt;
import com.ca.adr.ui.CadrPointLearn;
import com.ca.adr.ui.Shortcuts;
import com.ca.adr.ui.Ui;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BCadrPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BCadrPointManager.class);

    public Type getType() {
        return TYPE;
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new CadrPointLearn(this);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    static class State
    extends PointState {
        BOrd root;
        Object[] roots;
        BCadrPointDiscoveryJob job;

        protected void saveForType(BAbstractManager m) {
            super.saveForType(m);
            CadrPointLearn l = this.x(m.getLearn());
            this.root = this.root(m.getCurrentValue().asComponent());
            this.roots = l.getRoots();
            this.job = l.getCadrJob();
        }

        protected void restoreForType(BAbstractManager m) {
            super.restoreForType(m);
            try {
                BOrd arg = this.root(m.getCurrentValue().asComponent());
                if (this.root != null && this.root.equals((Object)arg)) {
                    CadrPointLearn l = this.x(m.getLearn());
                    l.setCadrJob(this.job);
                    l.updateRoots(this.roots);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private BOrd root(BComponent comp) {
            return comp.getHandleOrd();
        }

        private CadrPointLearn x(MgrLearn o) {
            return (CadrPointLearn)o;
        }
    }

    static class Model
    extends PointModel {
        MgrColumn sigName;
        MgrColumn sigType;
        MgrColumn deviceFacets;
        MgrColumn facets;

        public Model(BCadrPointManager manager) {
            super((BPointManager)manager);
        }

        public Type getFolderType() {
            return BCadrPointFolder.TYPE;
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE)};
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BComponent ret = type.newInstance();
            if (ret instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)ret;
                BCadrProxyExt ext = new BCadrProxyExt();
                pt.setProxyExt((BAbstractProxyExt)ext);
                pt.add(SlotPath.escape((String)Ui.lex("optOut")), (BValue)new BCadrOptOut());
                pt.add(SlotPath.escape((String)Ui.lex("optIn")), (BValue)new BCadrOptIn());
            }
            return ret;
        }

        protected MgrColumn[] makeColumns() {
            int e = 1;
            int eu = 3;
            int u = 2;
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Type(), new MgrColumn.ToString(Ui.lex("payload"), 0), this.sigName = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.signalNames}, e), this.sigType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.signalTypes}, e), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.eventId}, 0), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.eventState}, 0), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.testEvent}, 0), new Shortcuts(), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, eu), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.programs}, eu), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.eventTargets}, eu), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.signalTargets}, eu), this.facets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, eu), this.deviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, eu), new MgrColumn.Path(2), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BCadrProxyExt.signal}, u), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, eu), new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, u)};
        }
    }

    static class Controller
    extends PointController {
        public Controller(BCadrPointManager mgr) {
            super((BPointManager)mgr);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BComponent comp = (BComponent)this.getManager().getCurrentValue();
            Slot s = comp.getSlot("submitDiscoveryJob");
            if (s == null) {
                return null;
            }
            Action a = (Action)s;
            BOrd job = (BOrd)comp.invoke(a, null);
            this.getManager().getLearn().setJob(job);
            this.getManager().registerForComponentEvents((BComponent)this.getManager().getLearn().getJob());
            return null;
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            MgrColumn mgrCol = table.columnIndexToMgrColumn(col);
            if (mgrCol instanceof Shortcuts) {
                ((Shortcuts)mgrCol).cellDoubleClicked(table, event, row, col);
            } else {
                super.cellDoubleClicked(table, event, row, col);
            }
        }
    }
}

